/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.time.DurationMin;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.launcher.titus")
@Validated
public class TitusAgentLauncherProperties {
    public static final String PREFIX = "genie.agent.launcher.titus";
    public static final String ADDITIONAL_BANDWIDTH_PROPERTY = "genie.agent.launcher.titus.additionalBandwidth";
    public static final String ADDITIONAL_CPU_PROPERTY = "genie.agent.launcher.titus.additionalCPU";
    public static final String ADDITIONAL_DISK_SIZE_PROPERTY = "genie.agent.launcher.titus.additionalDiskSize";
    public static final String ADDITIONAL_ENVIRONMENT_PROPERTY = "genie.agent.launcher.titus.additional-environment";
    public static final String ADDITIONAL_GPU_PROPERTY = "genie.agent.launcher.titus.additionalGPU";
    public static final String ADDITIONAL_JOB_ATTRIBUTES_PROPERTY = "genie.agent.launcher.titus.additional-job-attributes";
    public static final String ADDITIONAL_MEMORY_PROPERTY = "genie.agent.launcher.titus.additionalMemory";
    public static final String CAPACITY_GROUP_PROPERTY = "genie.agent.launcher.titus.capacityGroup";
    public static final String CONTAINER_ATTRIBUTES_PROPERTY = "genie.agent.launcher.titus.container-attributes";
    public static final String ENABLE_PROPERTY = "genie.agent.launcher.titus.enabled";
    public static final String IMAGE_NAME_PROPERTY = "genie.agent.launcher.titus.imageName";
    public static final String IMAGE_TAG_PROPERTY = "genie.agent.launcher.titus.imageTag";
    public static final String MINIMUM_BANDWIDTH_PROPERTY = "genie.agent.launcher.titus.minimumBandwidth";
    public static final String MINIMUM_CPU_PROPERTY = "genie.agent.launcher.titus.minimumCPU";
    public static final String MINIMUM_DISK_SIZE_PROPERTY = "genie.agent.launcher.titus.minimumDiskSize";
    public static final String MINIMUM_GPU_PROPERTY = "genie.agent.launcher.titus.minimumGPU";
    public static final String MINIMUM_MEMORY_PROPERTY = "genie.agent.launcher.titus.minimumMemory";
    public static final String RETRIES_PROPERTY = "genie.agent.launcher.titus.retries";
    public static final String RUNTIME_LIMIT = "genie.agent.launcher.titus.runtimeLimit";
    public static final String JOB_ID_PLACEHOLDER = "<JOB_ID>";
    public static final String SERVER_HOST_PLACEHOLDER = "<SERVER_HOST>";
    public static final String SERVER_PORT_PLACEHOLDER = "<SERVER_PORT>";
    public static final String AGENT_IMAGE_KEY_PROPERTY = "genie.agent.launcher.titus.agentImageKey";
    public static final String CONTAINER_NETWORK_MODE = "genie.agent.launcher.titus.networkMode";
    private boolean enabled;
    private URI endpoint = URI.create("https://example-titus-endpoint.tld:1234");
    private List<@NotBlank String> entryPointTemplate = Arrays.asList("/bin/genie-agent");
    private List<@NotBlank String> commandTemplate = Arrays.asList("exec", "--api-job", "--launchInJobDirectory", "--job-id", "<JOB_ID>", "--server-host", "<SERVER_HOST>", "--server-port", "<SERVER_PORT>");
    @NotEmpty
    private String ownerEmail = "owners@genie.tld";
    @NotEmpty
    private String applicationName = "genie";
    @NotEmpty
    private String capacityGroup = "default";
    @NotNull
    private Map<String, String> securityAttributes = new HashMap<String, String>();
    @NotNull
    private List<String> securityGroups = new ArrayList<String>();
    @NotEmpty
    private String iAmRole = "arn:aws:iam::000000000:role/SomeProfile";
    @NotEmpty
    private String imageName = "image-name";
    @NotEmpty
    private String imageTag = "latest";
    @Min(value=0L)
    private @Min(value=0L) int retries;
    @DurationMin
    private Duration runtimeLimit = Duration.ofHours(12L);
    @NotEmpty
    private String genieServerHost = "example.genie.tld";
    @Min(value=0L)
    private @Min(value=0L) int genieServerPort = 9090;
    @Min(value=0L)
    private @Min(value=0L) int healthIndicatorMaxSize = 100;
    @DurationMin
    private Duration healthIndicatorExpiration = Duration.ofMinutes(30L);
    @NotNull
    private Map<String, String> additionalEnvironment = new HashMap<String, String>();
    private DataSize additionalBandwidth = DataSize.ofBytes((long)0L);
    @Min(value=0L)
    private @Min(value=0L) int additionalCPU = 1;
    private DataSize additionalDiskSize = DataSize.ofGigabytes((long)1L);
    @Min(value=0L)
    private @Min(value=0L) int additionalGPU;
    private DataSize additionalMemory = DataSize.ofGigabytes((long)2L);
    @NotNull
    private DataSize minimumBandwidth = DataSize.ofMegabytes((long)7L);
    @Min(value=1L)
    private @Min(value=1L) int minimumCPU = 1;
    @NotNull
    private DataSize minimumDiskSize = DataSize.ofGigabytes((long)10L);
    @Min(value=0L)
    private @Min(value=0L) int minimumGPU;
    @NotNull
    private DataSize minimumMemory = DataSize.ofGigabytes((long)4L);
    @NotNull
    private Map<String, String> containerAttributes = new HashMap<String, String>();
    @NotNull
    private Map<String, String> additionalJobAttributes = new HashMap<String, String>();
    private String stack = "";
    private String detail = "";
    private String sequence = "";
    private String agentImageKey = "genieAgent";

    public boolean isEnabled() {
        return this.enabled;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public List<@NotBlank String> getEntryPointTemplate() {
        return this.entryPointTemplate;
    }

    public List<@NotBlank String> getCommandTemplate() {
        return this.commandTemplate;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getCapacityGroup() {
        return this.capacityGroup;
    }

    @NotNull
    public Map<String, String> getSecurityAttributes() {
        return this.securityAttributes;
    }

    @NotNull
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getIAmRole() {
        return this.iAmRole;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public int getRetries() {
        return this.retries;
    }

    public Duration getRuntimeLimit() {
        return this.runtimeLimit;
    }

    public String getGenieServerHost() {
        return this.genieServerHost;
    }

    public int getGenieServerPort() {
        return this.genieServerPort;
    }

    public int getHealthIndicatorMaxSize() {
        return this.healthIndicatorMaxSize;
    }

    public Duration getHealthIndicatorExpiration() {
        return this.healthIndicatorExpiration;
    }

    @NotNull
    public Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnvironment;
    }

    public DataSize getAdditionalBandwidth() {
        return this.additionalBandwidth;
    }

    public int getAdditionalCPU() {
        return this.additionalCPU;
    }

    public DataSize getAdditionalDiskSize() {
        return this.additionalDiskSize;
    }

    public int getAdditionalGPU() {
        return this.additionalGPU;
    }

    public DataSize getAdditionalMemory() {
        return this.additionalMemory;
    }

    @NotNull
    public DataSize getMinimumBandwidth() {
        return this.minimumBandwidth;
    }

    public int getMinimumCPU() {
        return this.minimumCPU;
    }

    @NotNull
    public DataSize getMinimumDiskSize() {
        return this.minimumDiskSize;
    }

    public int getMinimumGPU() {
        return this.minimumGPU;
    }

    @NotNull
    public DataSize getMinimumMemory() {
        return this.minimumMemory;
    }

    @NotNull
    public Map<String, String> getContainerAttributes() {
        return this.containerAttributes;
    }

    @NotNull
    public Map<String, String> getAdditionalJobAttributes() {
        return this.additionalJobAttributes;
    }

    public String getStack() {
        return this.stack;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getAgentImageKey() {
        return this.agentImageKey;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public void setEntryPointTemplate(List<@NotBlank String> entryPointTemplate) {
        this.entryPointTemplate = entryPointTemplate;
    }

    public void setCommandTemplate(List<@NotBlank String> commandTemplate) {
        this.commandTemplate = commandTemplate;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setCapacityGroup(String capacityGroup) {
        this.capacityGroup = capacityGroup;
    }

    public void setSecurityAttributes(@NotNull Map<String, String> securityAttributes) {
        this.securityAttributes = securityAttributes;
    }

    public void setSecurityGroups(@NotNull List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public void setIAmRole(String iAmRole) {
        this.iAmRole = iAmRole;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setImageTag(String imageTag) {
        this.imageTag = imageTag;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRuntimeLimit(Duration runtimeLimit) {
        this.runtimeLimit = runtimeLimit;
    }

    public void setGenieServerHost(String genieServerHost) {
        this.genieServerHost = genieServerHost;
    }

    public void setGenieServerPort(int genieServerPort) {
        this.genieServerPort = genieServerPort;
    }

    public void setHealthIndicatorMaxSize(int healthIndicatorMaxSize) {
        this.healthIndicatorMaxSize = healthIndicatorMaxSize;
    }

    public void setHealthIndicatorExpiration(Duration healthIndicatorExpiration) {
        this.healthIndicatorExpiration = healthIndicatorExpiration;
    }

    public void setAdditionalEnvironment(@NotNull Map<String, String> additionalEnvironment) {
        this.additionalEnvironment = additionalEnvironment;
    }

    public void setAdditionalBandwidth(DataSize additionalBandwidth) {
        this.additionalBandwidth = additionalBandwidth;
    }

    public void setAdditionalCPU(int additionalCPU) {
        this.additionalCPU = additionalCPU;
    }

    public void setAdditionalDiskSize(DataSize additionalDiskSize) {
        this.additionalDiskSize = additionalDiskSize;
    }

    public void setAdditionalGPU(int additionalGPU) {
        this.additionalGPU = additionalGPU;
    }

    public void setAdditionalMemory(DataSize additionalMemory) {
        this.additionalMemory = additionalMemory;
    }

    public void setMinimumBandwidth(@NotNull DataSize minimumBandwidth) {
        this.minimumBandwidth = minimumBandwidth;
    }

    public void setMinimumCPU(int minimumCPU) {
        this.minimumCPU = minimumCPU;
    }

    public void setMinimumDiskSize(@NotNull DataSize minimumDiskSize) {
        this.minimumDiskSize = minimumDiskSize;
    }

    public void setMinimumGPU(int minimumGPU) {
        this.minimumGPU = minimumGPU;
    }

    public void setMinimumMemory(@NotNull DataSize minimumMemory) {
        this.minimumMemory = minimumMemory;
    }

    public void setContainerAttributes(@NotNull Map<String, String> containerAttributes) {
        this.containerAttributes = containerAttributes;
    }

    public void setAdditionalJobAttributes(@NotNull Map<String, String> additionalJobAttributes) {
        this.additionalJobAttributes = additionalJobAttributes;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public void setAgentImageKey(String agentImageKey) {
        this.agentImageKey = agentImageKey;
    }
}

