/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.netflix.genie.common.internal.util.PropertiesMapCache;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.AgentLauncherSelectorScriptProperties;
import com.netflix.genie.web.scripts.ResourceSelectorScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.scripts.ScriptManager;
import com.netflix.genie.web.selectors.AgentLauncherSelectionContext;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentLauncherSelectorManagedScript
extends ResourceSelectorScript<AgentLauncher, AgentLauncherSelectionContext> {
    private static final Logger log = LoggerFactory.getLogger(AgentLauncherSelectorManagedScript.class);
    static final String AGENT_LAUNCHERS_BINDING = "agentLaunchersParameter";

    public AgentLauncherSelectorManagedScript(ScriptManager scriptManager, AgentLauncherSelectorScriptProperties properties, MeterRegistry registry, PropertiesMapCache propertyMapCache) {
        super(scriptManager, properties, registry, propertyMapCache);
    }

    @Override
    public ResourceSelectorScriptResult<AgentLauncher> selectResource(AgentLauncherSelectionContext context) throws ResourceSelectionException {
        log.debug("Called to attempt to select agent launcher from {} for job {}", context.getAgentLaunchers(), (Object)context.getJobId());
        return super.selectResource(context);
    }

    @Override
    protected void addParametersForScript(Map<String, Object> parameters, AgentLauncherSelectionContext context) {
        super.addParametersForScript(parameters, context);
        parameters.put(AGENT_LAUNCHERS_BINDING, context.getAgentLaunchers());
    }
}

