/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors;

import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.internal.dtos.Cluster;
import com.netflix.genie.common.internal.dtos.Command;
import com.netflix.genie.common.internal.dtos.JobRequest;
import com.netflix.genie.web.selectors.ResourceSelectionContext;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class CommandSelectionContext
extends ResourceSelectionContext<Command> {
    private final Map<Command, Set<Cluster>> commandToClusters;

    public CommandSelectionContext(@NotBlank String jobId, @NotNull JobRequest jobRequest, boolean apiJob, @NotEmpty @NotEmpty Map<@Valid Command, @NotEmpty Set<@Valid Cluster>> commandToClusters) {
        super(jobId, jobRequest, apiJob);
        this.commandToClusters = ImmutableMap.copyOf(commandToClusters);
    }

    @Override
    public Set<Command> getResources() {
        return this.commandToClusters.keySet();
    }

    public Map<Command, Set<Cluster>> getCommandToClusters() {
        return this.commandToClusters;
    }

    @Override
    public String toString() {
        return "CommandSelectionContext(super=" + super.toString() + ", commandToClusters=" + this.commandToClusters + ")";
    }
}

