/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure;

import com.netflix.genie.web.agent.services.impl.AgentRoutingServiceCuratorDiscoveryImpl;
import com.netflix.genie.web.properties.ZookeeperProperties;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.zookeeper.config.LeaderInitiatorFactoryBean;

@Configuration
@EnableConfigurationProperties(value={ZookeeperProperties.class})
@AutoConfigureAfter(value={org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration.class})
@ConditionalOnBean(value={CuratorFramework.class})
public class ZookeeperAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LeaderInitiatorFactoryBean.class})
    public LeaderInitiatorFactoryBean leaderInitiatorFactory(CuratorFramework client, ZookeeperProperties zookeeperProperties) {
        LeaderInitiatorFactoryBean factoryBean = new LeaderInitiatorFactoryBean();
        factoryBean.setClient(client);
        factoryBean.setPath(zookeeperProperties.getLeaderPath());
        factoryBean.setRole("cluster");
        return factoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceDiscovery.class})
    ServiceDiscovery<AgentRoutingServiceCuratorDiscoveryImpl.Agent> serviceDiscovery(CuratorFramework client, ZookeeperProperties zookeeperProperties) {
        return ServiceDiscoveryBuilder.builder(AgentRoutingServiceCuratorDiscoveryImpl.Agent.class).basePath(zookeeperProperties.getDiscoveryPath()).client(client).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={Listenable.class})
    Listenable<ConnectionStateListener> listenableCuratorConnectionState(CuratorFramework client) {
        return client.getConnectionStateListenable();
    }
}

