/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.introspection;

import com.netflix.genie.common.internal.util.HostnameUtil;
import com.netflix.genie.web.agent.apis.rpc.servers.GRpcServerUtils;
import com.netflix.genie.web.introspection.GenieWebHostInfo;
import com.netflix.genie.web.introspection.GenieWebRpcInfo;
import com.netflix.genie.web.spring.autoconfigure.agent.apis.rpc.servers.AgentRpcServersAutoConfiguration;
import io.grpc.Server;
import java.net.UnknownHostException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AgentRpcServersAutoConfiguration.class})
public class IntrospectionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GenieWebHostInfo.class})
    public GenieWebHostInfo genieHostInfo() throws UnknownHostException {
        String hostname = HostnameUtil.getHostname();
        return new GenieWebHostInfo(hostname);
    }

    @Bean
    @ConditionalOnMissingBean(value={GenieWebRpcInfo.class})
    public GenieWebRpcInfo genieWebRpcInfo(Server server) throws IllegalStateException {
        if (server.isShutdown() || server.isTerminated()) {
            throw new IllegalStateException("gRPC server is already shut down. Can't start.");
        }
        int port = GRpcServerUtils.startServer(server);
        if (port < 1) {
            throw new IllegalStateException("gRPC server started on illegal port: " + port);
        }
        return new GenieWebRpcInfo(port);
    }
}

