/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.dtos.ArchiveStatus;
import com.netflix.genie.common.internal.dtos.JobStatus;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.properties.AgentCleanupProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.leader.LeaderTask;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentJobCleanupTask
extends LeaderTask {
    private static final Logger log = LoggerFactory.getLogger(AgentJobCleanupTask.class);
    private static final String AWOL_STATUS_MESSAGE = "Agent AWOL for too long";
    private static final String NEVER_CLAIMED_STATUS_MESSAGE = "No agent claimed the job for too long";
    private static final String TERMINATED_COUNTER_METRIC_NAME = "genie.jobs.agentDisconnected.terminated.counter";
    private static final String DISCONNECTED_GAUGE_METRIC_NAME = "genie.jobs.agentDisconnected.gauge";
    private final Map<String, Instant> awolJobsMap;
    private final PersistenceService persistenceService;
    private final AgentCleanupProperties properties;
    private final MeterRegistry registry;
    private final AgentRoutingService agentRoutingService;

    public AgentJobCleanupTask(DataServices dataServices, AgentCleanupProperties properties, MeterRegistry registry, AgentRoutingService agentRoutingService) {
        this.persistenceService = dataServices.getPersistenceService();
        this.properties = properties;
        this.registry = registry;
        this.agentRoutingService = agentRoutingService;
        this.awolJobsMap = Maps.newConcurrentMap();
        this.registry.gaugeMapSize(DISCONNECTED_GAUGE_METRIC_NAME, (Iterable)Sets.newHashSet(), this.awolJobsMap);
    }

    @Override
    public void run() {
        Set<String> activeAgentJobIds = this.persistenceService.getActiveJobs();
        Set<String> acceptedAgentJobIds = this.persistenceService.getUnclaimedJobs();
        Set<String> currentlyAwolJobsIds = activeAgentJobIds.stream().filter(jobId -> !this.agentRoutingService.isAgentConnected((String)jobId)).collect(Collectors.toSet());
        this.awolJobsMap.entrySet().removeIf(awolJobEntry -> !currentlyAwolJobsIds.contains(awolJobEntry.getKey()));
        Instant now = Instant.now();
        currentlyAwolJobsIds.forEach(jobId -> this.awolJobsMap.putIfAbsent((String)jobId, now));
        for (Map.Entry<String, Instant> entry : this.awolJobsMap.entrySet()) {
            String awolJobId = entry.getKey();
            Instant awolJobFirstSeen = entry.getValue();
            boolean jobWasClaimed = !acceptedAgentJobIds.contains(awolJobId);
            Instant claimDeadline = awolJobFirstSeen.plus(this.properties.getLaunchTimeLimit());
            Instant reconnectDeadline = awolJobFirstSeen.plus(this.properties.getReconnectTimeLimit());
            if (!jobWasClaimed && now.isBefore(claimDeadline)) {
                log.debug("Job {} agent still pending agent start/claim", (Object)awolJobId);
                continue;
            }
            if (jobWasClaimed && now.isBefore(reconnectDeadline)) {
                log.debug("Job {} agent still disconnected", (Object)awolJobId);
                continue;
            }
            log.warn("Job {} agent AWOL for too long, marking failed", (Object)awolJobId);
            try {
                JobStatus currentStatus = this.persistenceService.getJobStatus(awolJobId);
                ArchiveStatus archiveStatus = this.persistenceService.getJobArchiveStatus(awolJobId);
                if (archiveStatus == ArchiveStatus.PENDING) {
                    this.persistenceService.updateJobArchiveStatus(awolJobId, jobWasClaimed ? ArchiveStatus.UNKNOWN : ArchiveStatus.FAILED);
                }
                this.persistenceService.updateJobStatus(awolJobId, currentStatus, JobStatus.FAILED, jobWasClaimed ? AWOL_STATUS_MESSAGE : NEVER_CLAIMED_STATUS_MESSAGE);
                this.awolJobsMap.remove(awolJobId);
                this.registry.counter(TERMINATED_COUNTER_METRIC_NAME, MetricsUtils.newSuccessTagsSet()).increment();
            }
            catch (GenieInvalidStatusException | NotFoundException e) {
                log.warn("Failed to mark AWOL job {} as failed: ", (Object)awolJobId, e);
                this.registry.counter(TERMINATED_COUNTER_METRIC_NAME, MetricsUtils.newFailureTagsSetForException((Throwable)e)).increment();
            }
        }
    }

    @Override
    public void cleanup() {
        this.awolJobsMap.clear();
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.FIXED_RATE;
    }

    @Override
    public long getFixedRate() {
        return this.properties.getRefreshInterval().toMillis();
    }
}

