/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.internal.dtos.JobStatus;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.properties.UserMetricsProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.leader.LeaderTask;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMetricsTask
extends LeaderTask {
    private static final Logger log = LoggerFactory.getLogger(UserMetricsTask.class);
    private static final String USER_ACTIVE_JOBS_METRIC_NAME = "genie.user.active-jobs.gauge";
    private static final String USER_ACTIVE_MEMORY_METRIC_NAME = "genie.user.active-memory.gauge";
    private static final String USER_ACTIVE_USERS_METRIC_NAME = "genie.user.active-users.gauge";
    private static final UserResourcesRecord USER_RECORD_PLACEHOLDER = new UserResourcesRecord("nobody");
    private final MeterRegistry registry;
    private final PersistenceService persistenceService;
    private final UserMetricsProperties userMetricsProperties;
    private final Map<String, UserResourcesRecord> userResourcesRecordMap = Maps.newHashMap();
    private final AtomicDouble activeUsersCount;

    public UserMetricsTask(MeterRegistry registry, DataServices dataServices, UserMetricsProperties userMetricsProperties) {
        this.registry = registry;
        this.persistenceService = dataServices.getPersistenceService();
        this.userMetricsProperties = userMetricsProperties;
        this.activeUsersCount = new AtomicDouble(Double.NaN);
        Gauge.builder((String)USER_ACTIVE_USERS_METRIC_NAME, this::getUsersCount).register(registry);
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.FIXED_RATE;
    }

    @Override
    public long getFixedRate() {
        return this.userMetricsProperties.getRefreshInterval();
    }

    @Override
    public void run() {
        log.debug("Publishing user metrics");
        Map<String, UserResourcesSummary> summaries = this.persistenceService.getUserResourcesSummaries(JobStatus.getActiveStatuses(), true);
        log.debug("Number of users with active jobs: {}", (Object)summaries.size());
        this.activeUsersCount.set((double)summaries.size());
        HashSet usersToReset = Sets.newHashSet(this.userResourcesRecordMap.keySet());
        usersToReset.removeAll(summaries.keySet());
        for (String user : usersToReset) {
            this.userResourcesRecordMap.remove(user);
        }
        for (UserResourcesSummary userResourcesSummary : summaries.values()) {
            String user = userResourcesSummary.getUser();
            long jobs = userResourcesSummary.getRunningJobsCount();
            long memory = userResourcesSummary.getUsedMemory();
            log.debug("User {}: {} jobs running, using {}MB", new Object[]{user, jobs, memory});
            this.userResourcesRecordMap.computeIfAbsent(userResourcesSummary.getUser(), userName -> {
                Gauge.builder((String)USER_ACTIVE_JOBS_METRIC_NAME, () -> this.getUserJobCount((String)userName)).tags(new String[]{"user", userName}).register(this.registry);
                Gauge.builder((String)USER_ACTIVE_MEMORY_METRIC_NAME, () -> this.getUserMemoryAmount((String)userName)).tags(new String[]{"user", userName}).register(this.registry);
                return new UserResourcesRecord((String)userName);
            }).update(jobs, memory);
        }
        log.debug("Done publishing user metrics");
    }

    @Override
    public void cleanup() {
        log.debug("Cleaning up user metrics publishing");
        this.userResourcesRecordMap.clear();
        this.activeUsersCount.set(Double.NaN);
    }

    private Number getUserJobCount(String userName) {
        UserResourcesRecord record = this.userResourcesRecordMap.getOrDefault(userName, USER_RECORD_PLACEHOLDER);
        double jobCount = record.jobCount.get();
        log.debug("Current jobs count for user '{}' is {}", (Object)userName, (Object)((long)jobCount));
        return jobCount;
    }

    private Number getUserMemoryAmount(String userName) {
        UserResourcesRecord record = this.userResourcesRecordMap.getOrDefault(userName, USER_RECORD_PLACEHOLDER);
        double memoryAmount = record.memoryAmount.get();
        log.debug("Current memory amount for user '{}' is {}MB", (Object)userName, (Object)((long)memoryAmount));
        return memoryAmount;
    }

    private Number getUsersCount() {
        return this.activeUsersCount.get();
    }

    private static class UserResourcesRecord {
        private final String userName;
        private final AtomicDouble jobCount = new AtomicDouble(Double.NaN);
        private final AtomicDouble memoryAmount = new AtomicDouble(Double.NaN);

        UserResourcesRecord(String userName) {
            this.userName = userName;
        }

        void update(long runningJobsCount, long usedMemory) {
            log.debug("Updating usage of user '{}': {} jobs totalling {}MB", new Object[]{this.userName, runningJobsCount, usedMemory});
            this.jobCount.set((double)runningJobsCount);
            this.memoryAmount.set((double)usedMemory);
        }
    }
}

