/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.converters;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netflix.genie.common.dto.ArchiveStatus;
import com.netflix.genie.common.dto.ContainerImage;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.Runtime;
import com.netflix.genie.common.dto.RuntimeResources;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.Image;
import com.netflix.genie.common.internal.dtos.JobStatus;
import com.netflix.genie.common.internal.dtos.converters.DtoConverters;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.aggregates.UserJobResourcesAggregate;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobExecutionProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobMetadataProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobProjection;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityV3DtoConverters {
    private static final Logger log = LoggerFactory.getLogger(EntityV3DtoConverters.class);
    private static final TypeReference<Map<String, Image>> IMAGES_TYPE_REFERENCE = new TypeReference<Map<String, Image>>(){};
    private static final ObjectNode EMPTY_JSON = GenieObjectMapper.getMapper().createObjectNode();

    private EntityV3DtoConverters() {
    }

    public static Job toJobDto(JobProjection jobProjection) {
        Job.Builder builder = ((Job.Builder)((Job.Builder)((Job.Builder)((Job.Builder)new Job.Builder(jobProjection.getName(), jobProjection.getUser(), jobProjection.getVersion()).withId(jobProjection.getUniqueId())).withCreated(jobProjection.getCreated())).withUpdated(jobProjection.getUpdated())).withTags(jobProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withStatus(DtoConverters.toV3JobStatus((JobStatus)DtoConverters.toV4JobStatus((String)jobProjection.getStatus()))).withCommandArgs(jobProjection.getCommandArgs());
        jobProjection.getDescription().ifPresent(arg_0 -> ((Job.Builder)builder).withDescription(arg_0));
        jobProjection.getStatusMsg().ifPresent(arg_0 -> ((Job.Builder)builder).withStatusMsg(arg_0));
        jobProjection.getStarted().ifPresent(arg_0 -> ((Job.Builder)builder).withStarted(arg_0));
        jobProjection.getFinished().ifPresent(arg_0 -> ((Job.Builder)builder).withFinished(arg_0));
        jobProjection.getArchiveLocation().ifPresent(arg_0 -> ((Job.Builder)builder).withArchiveLocation(arg_0));
        jobProjection.getClusterName().ifPresent(arg_0 -> ((Job.Builder)builder).withClusterName(arg_0));
        jobProjection.getCommandName().ifPresent(arg_0 -> ((Job.Builder)builder).withCommandName(arg_0));
        jobProjection.getGrouping().ifPresent(arg_0 -> ((Job.Builder)builder).withGrouping(arg_0));
        jobProjection.getGroupingInstance().ifPresent(arg_0 -> ((Job.Builder)builder).withGroupingInstance(arg_0));
        jobProjection.getMetadata().ifPresent(arg_0 -> ((Job.Builder)builder).withMetadata(arg_0));
        return builder.build();
    }

    public static JobExecution toJobExecutionDto(JobExecutionProjection jobExecutionProjection) {
        JobExecution.Builder builder = (JobExecution.Builder)((JobExecution.Builder)((JobExecution.Builder)new JobExecution.Builder(jobExecutionProjection.getAgentHostname().orElse(UUID.randomUUID().toString())).withId(jobExecutionProjection.getUniqueId())).withCreated(jobExecutionProjection.getCreated())).withUpdated(jobExecutionProjection.getUpdated());
        jobExecutionProjection.getProcessId().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withProcessId(arg_0));
        if (jobExecutionProjection.getStarted().isPresent() && jobExecutionProjection.getTimeoutUsed().isPresent()) {
            Instant started = jobExecutionProjection.getStarted().get();
            builder.withTimeout(started.plusSeconds(jobExecutionProjection.getTimeoutUsed().get().intValue()));
        }
        jobExecutionProjection.getExitCode().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withExitCode(arg_0));
        RuntimeResources.Builder resourcesBuilder = new RuntimeResources.Builder();
        jobExecutionProjection.getCpuUsed().ifPresent(arg_0 -> ((RuntimeResources.Builder)resourcesBuilder).withCpu(arg_0));
        jobExecutionProjection.getGpuUsed().ifPresent(arg_0 -> ((RuntimeResources.Builder)resourcesBuilder).withGpu(arg_0));
        jobExecutionProjection.getMemoryUsed().ifPresent(arg_0 -> ((RuntimeResources.Builder)resourcesBuilder).withMemoryMb(arg_0));
        jobExecutionProjection.getDiskMbUsed().ifPresent(arg_0 -> ((RuntimeResources.Builder)resourcesBuilder).withDiskMb(arg_0));
        jobExecutionProjection.getNetworkMbpsUsed().ifPresent(arg_0 -> ((RuntimeResources.Builder)resourcesBuilder).withNetworkMbps(arg_0));
        Map<String, ContainerImage> images = ((Map)GenieObjectMapper.getMapper().convertValue((Object)jobExecutionProjection.getImagesUsed().orElse((JsonNode)EMPTY_JSON), IMAGES_TYPE_REFERENCE)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DtoConverters.toV3ContainerImage((Image)((Image)entry.getValue()))));
        builder.withRuntime(new Runtime.Builder().withResources(resourcesBuilder.build()).withImages(images).build());
        try {
            builder.withArchiveStatus(ArchiveStatus.valueOf((String)jobExecutionProjection.getArchiveStatus().orElseThrow(IllegalArgumentException::new)));
        }
        catch (IllegalArgumentException e) {
            builder.withArchiveStatus(ArchiveStatus.UNKNOWN);
        }
        jobExecutionProjection.getLauncherExt().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withLauncherExt(arg_0));
        return builder.build();
    }

    public static JobMetadata toJobMetadataDto(JobMetadataProjection jobMetadataProjection) {
        JobMetadata.Builder builder = (JobMetadata.Builder)((JobMetadata.Builder)((JobMetadata.Builder)new JobMetadata.Builder().withId(jobMetadataProjection.getUniqueId())).withCreated(jobMetadataProjection.getCreated())).withUpdated(jobMetadataProjection.getUpdated());
        jobMetadataProjection.getRequestApiClientHostname().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withClientHost(arg_0));
        jobMetadataProjection.getRequestApiClientUserAgent().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withUserAgent(arg_0));
        jobMetadataProjection.getNumAttachments().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withNumAttachments(arg_0));
        jobMetadataProjection.getTotalSizeOfAttachments().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withTotalSizeOfAttachments(arg_0));
        jobMetadataProjection.getStdErrSize().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withStdErrSize(arg_0));
        jobMetadataProjection.getStdOutSize().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withStdOutSize(arg_0));
        return builder.build();
    }

    public static UserResourcesSummary toUserResourceSummaryDto(UserJobResourcesAggregate userJobResourcesAggregate) {
        String user = userJobResourcesAggregate.getUser();
        Long jobCount = userJobResourcesAggregate.getRunningJobsCount();
        Long memory = userJobResourcesAggregate.getUsedMemory();
        return new UserResourcesSummary(user == null ? "NULL" : user, jobCount == null ? 0L : jobCount, memory == null ? 0L : memory);
    }
}

