/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.queries.predicates;

import com.google.common.collect.Lists;
import com.netflix.genie.common.internal.dtos.Criterion;
import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.IdEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.UniqueIdEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public final class PredicateUtils {
    static final String PERCENT = "%";
    static final String TAG_DELIMITER = "|";

    private PredicateUtils() {
    }

    public static String createTagSearchString(Set<TagEntity> tags) {
        return TAG_DELIMITER + tags.stream().map(TagEntity::getTag).sorted(String.CASE_INSENSITIVE_ORDER).reduce((one, two) -> one + "||" + two).orElse("") + TAG_DELIMITER;
    }

    static Predicate getStringLikeOrEqualPredicate(@NotNull CriteriaBuilder cb, @NotNull Expression<String> expression, @NotNull String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)PERCENT)) {
            return cb.like(expression, value);
        }
        return cb.equal(expression, (Object)value);
    }

    static String getTagLikeString(@NotNull Set<String> tags) {
        StringBuilder builder = new StringBuilder();
        tags.stream().filter(StringUtils::isNotBlank).sorted(String.CASE_INSENSITIVE_ORDER).forEach(tag -> builder.append(PERCENT).append(TAG_DELIMITER).append((String)tag).append(TAG_DELIMITER));
        return builder.append(PERCENT).toString();
    }

    static <E extends BaseEntity> Predicate createCriterionPredicate(Root<E> root, AbstractQuery<?> cq, CriteriaBuilder cb, SingularAttribute<UniqueIdEntity, String> uniqueIdAttribute, SingularAttribute<BaseEntity, String> nameAttribute, SingularAttribute<BaseEntity, String> versionAttribute, SingularAttribute<BaseEntity, String> statusAttribute, Supplier<Join<E, TagEntity>> tagJoinSupplier, SingularAttribute<IdEntity, Long> idAttribute, Criterion criterion) {
        ArrayList predicates = Lists.newArrayList();
        criterion.getId().ifPresent(id -> predicates.add(cb.equal((Expression)root.get(uniqueIdAttribute), id)));
        criterion.getName().ifPresent(name -> predicates.add(cb.equal((Expression)root.get(nameAttribute), name)));
        criterion.getVersion().ifPresent(version -> predicates.add(cb.equal((Expression)root.get(versionAttribute), version)));
        criterion.getStatus().ifPresent(status -> predicates.add(cb.equal((Expression)root.get(statusAttribute), status)));
        Set tags = criterion.getTags();
        if (!tags.isEmpty()) {
            Join<E, TagEntity> tagJoin = tagJoinSupplier.get();
            predicates.add(tagJoin.get(TagEntity_.tag).in((Collection)tags));
            cq.groupBy(new Expression[]{root.get(idAttribute)});
            cq.having((Expression)cb.equal(cb.count((Expression)root.get(idAttribute)), (Object)tags.size()));
        }
        return cb.and(predicates.toArray(new Predicate[0]));
    }
}

