/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import brave.SpanCustomizer;
import brave.Tracer;
import com.netflix.genie.common.internal.dtos.Application;
import com.netflix.genie.common.internal.dtos.Cluster;
import com.netflix.genie.common.internal.dtos.ClusterMetadata;
import com.netflix.genie.common.internal.dtos.Command;
import com.netflix.genie.common.internal.dtos.CommonResource;
import com.netflix.genie.common.internal.dtos.ComputeResources;
import com.netflix.genie.common.internal.dtos.Criterion;
import com.netflix.genie.common.internal.dtos.Image;
import com.netflix.genie.common.internal.dtos.JobEnvironment;
import com.netflix.genie.common.internal.dtos.JobMetadata;
import com.netflix.genie.common.internal.dtos.JobRequest;
import com.netflix.genie.common.internal.dtos.JobSpecification;
import com.netflix.genie.common.internal.dtos.JobStatus;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobResolutionRuntimeException;
import com.netflix.genie.common.internal.tracing.brave.BraveTagAdapter;
import com.netflix.genie.common.internal.tracing.brave.BraveTracingComponents;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.JobResolutionProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.selectors.ClusterSelectionContext;
import com.netflix.genie.web.selectors.ClusterSelector;
import com.netflix.genie.web.selectors.CommandSelectionContext;
import com.netflix.genie.web.selectors.CommandSelector;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetClassAware;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class JobResolverServiceImpl
implements JobResolverService {
    private static final Logger LOG = LoggerFactory.getLogger(JobResolverServiceImpl.class);
    private static final String RESOLVE_JOB_TIMER = "genie.services.jobResolver.resolve.timer";
    private static final String RESOLVE_COMMAND_TIMER = "genie.services.jobResolver.resolveCommand.timer";
    private static final String RESOLVE_CLUSTER_TIMER = "genie.services.jobResolver.resolveCluster.timer";
    private static final String RESOLVE_APPLICATIONS_TIMER = "genie.services.jobResolver.resolveApplications.timer";
    private static final String GENERATE_CRITERIA_PERMUTATIONS_TIMER = "genie.services.jobResolver.generateClusterCriteriaPermutations.timer";
    private static final String CLUSTER_SELECTOR_COUNTER = "genie.services.jobResolver.resolveCluster.clusterSelector.counter";
    private static final int DEFAULT_CPU = 1;
    private static final int DEFAULT_GPU = 0;
    private static final long DEFAULT_MEMORY = 1500L;
    private static final long DEFAULT_DISK = 10000L;
    private static final long DEFAULT_NETWORK = 256L;
    private static final String NO_RATIONALE = "No rationale provided";
    private static final String NO_ID_FOUND = "No id found";
    private static final String VERSION_4 = "4";
    private static final Tag SAVED_TAG = Tag.of((String)"saved", (String)"true");
    private static final Tag NOT_SAVED_TAG = Tag.of((String)"saved", (String)"false");
    private static final Tag NO_CLUSTER_RESOLVED_ID = Tag.of((String)"clusterId", (String)"None Resolved");
    private static final Tag NO_CLUSTER_RESOLVED_NAME = Tag.of((String)"clusterName", (String)"None Resolved");
    private static final Tag NO_COMMAND_RESOLVED_ID = Tag.of((String)"commandId", (String)"None Resolved");
    private static final Tag NO_COMMAND_RESOLVED_NAME = Tag.of((String)"commandName", (String)"None Resolved");
    private static final String ID_FIELD = "id";
    private static final String NAME_FIELD = "name";
    private static final String STATUS_FIELD = "status";
    private static final String VERSION_FIELD = "version";
    private static final String CLUSTER_SELECTOR_STATUS_SUCCESS = "success";
    private static final String CLUSTER_SELECTOR_STATUS_NO_PREFERENCE = "no preference";
    private final PersistenceService persistenceService;
    private final List<ClusterSelector> clusterSelectors;
    private final CommandSelector commandSelector;
    private final MeterRegistry registry;
    private final File defaultJobDirectory;
    private final String defaultArchiveLocation;
    private final Tracer tracer;
    private final BraveTagAdapter tagAdapter;
    private final JobResolutionProperties jobResolutionProperties;

    public JobResolverServiceImpl(DataServices dataServices, @NotEmpty List<ClusterSelector> clusterSelectors, CommandSelector commandSelector, MeterRegistry registry, JobsProperties jobsProperties, JobResolutionProperties jobResolutionProperties, BraveTracingComponents tracingComponents) {
        this.persistenceService = dataServices.getPersistenceService();
        this.clusterSelectors = clusterSelectors;
        this.commandSelector = commandSelector;
        this.jobResolutionProperties = jobResolutionProperties;
        URI jobDirProperty = jobsProperties.getLocations().getJobs();
        this.defaultJobDirectory = Paths.get(jobDirProperty).toFile();
        String archiveLocation = jobsProperties.getLocations().getArchives().toString();
        this.defaultArchiveLocation = archiveLocation.endsWith(File.separator) ? archiveLocation : archiveLocation + File.separator;
        this.registry = registry;
        this.tracer = tracingComponents.getTracer();
        this.tagAdapter = tracingComponents.getTagAdapter();
    }

    @Override
    @Nonnull
    @Transactional
    public ResolvedJob resolveJob(String id) throws GenieJobResolutionException, GenieJobResolutionRuntimeException {
        long start = System.nanoTime();
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(SAVED_TAG);
        try {
            LOG.info("Received request to resolve a job with id {}", (Object)id);
            JobStatus jobStatus = this.persistenceService.getJobStatus(id);
            if (!jobStatus.isResolvable()) {
                throw new IllegalArgumentException("Job " + id + " is already resolved: " + jobStatus);
            }
            JobRequest jobRequest = this.persistenceService.getJobRequest(id);
            boolean apiJob = this.persistenceService.isApiJob(id);
            JobResolutionContext context = new JobResolutionContext(id, jobRequest, apiJob, this.tracer.currentSpanCustomizer());
            ResolvedJob resolvedJob = this.resolve(context);
            this.persistenceService.saveResolvedJob(id, resolvedJob);
            MetricsUtils.addSuccessTags(tags);
            ResolvedJob resolvedJob2 = resolvedJob;
            return resolvedJob2;
        }
        catch (GenieJobResolutionException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionRuntimeException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_TIMER, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    @Nonnull
    public ResolvedJob resolveJob(String id, @Valid JobRequest jobRequest, boolean apiJob) throws GenieJobResolutionException, GenieJobResolutionRuntimeException {
        long start = System.nanoTime();
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(NOT_SAVED_TAG);
        try {
            LOG.info("Received request to resolve a job for id {} and request {}", (Object)id, (Object)jobRequest);
            JobResolutionContext context = new JobResolutionContext(id, jobRequest, apiJob, this.tracer.currentSpanCustomizer());
            ResolvedJob resolvedJob = this.resolve(context);
            MetricsUtils.addSuccessTags(tags);
            ResolvedJob resolvedJob2 = resolvedJob;
            return resolvedJob2;
        }
        catch (GenieJobResolutionException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionRuntimeException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_TIMER, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private ResolvedJob resolve(JobResolutionContext context) throws GenieJobResolutionException, GenieJobResolutionRuntimeException {
        this.tagSpanWithJobMetadata(context);
        this.resolveCommand(context);
        this.resolveCluster(context);
        this.resolveApplications(context);
        this.resolveComputeResources(context);
        this.resolveImages(context);
        this.resolveEnvironmentVariables(context);
        this.resolveTimeout(context);
        this.resolveArchiveLocation(context);
        this.resolveJobDirectory(context);
        return context.build();
    }

    private void resolveCommand(JobResolutionContext context) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet<Tag> tags = new HashSet<Tag>();
        try {
            JobRequest jobRequest = context.getJobRequest();
            Criterion criterion = jobRequest.getCriteria().getCommandCriterion();
            Set<Command> commands = this.persistenceService.findCommandsMatchingCriterion(criterion, true);
            if (commands.isEmpty()) {
                throw new GenieJobResolutionException("No command matching command criterion found");
            }
            Map<Command, List<Criterion>> commandClusterCriterions = this.generateClusterCriteriaPermutations(commands, jobRequest);
            Set<Criterion> uniqueCriteria = this.flattenClusterCriteriaPermutations(commandClusterCriterions);
            Set<Cluster> allCandidateClusters = this.persistenceService.findClustersMatchingAnyCriterion(uniqueCriteria, true);
            if (allCandidateClusters.isEmpty()) {
                throw new GenieJobResolutionException("No clusters available to run any candidate command on");
            }
            Map<Command, Set<Cluster>> commandClusters = this.generateCommandClustersMap(commandClusterCriterions, allCandidateClusters);
            if (commandClusters.isEmpty()) {
                throw new GenieJobResolutionException("No clusters available to run any candidate command on");
            }
            context.setCommandClusters(commandClusters);
            ResourceSelectionResult result = this.commandSelector.select(new CommandSelectionContext(context.getJobId(), jobRequest, context.isApiJob(), commandClusters));
            Command command = (Command)result.getSelectedResource().orElseThrow(() -> new GenieJobResolutionException("Expected a command but " + result.getSelectorClass().getSimpleName() + " didn't select anything. Rationale: " + result.getSelectionRationale().orElse(NO_RATIONALE)));
            LOG.debug("Selected command {} for criterion {} using {} due to {}", new Object[]{command.getId(), criterion, result.getSelectorClass().getName(), result.getSelectionRationale().orElse(NO_RATIONALE)});
            MetricsUtils.addSuccessTags(tags);
            String commandId = command.getId();
            String commandName = command.getMetadata().getName();
            tags.add(Tag.of((String)"commandId", (String)commandId));
            tags.add(Tag.of((String)"commandName", (String)commandName));
            SpanCustomizer spanCustomizer = context.getSpanCustomizer();
            this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.command.id", (Object)commandId);
            this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.command.name", (Object)commandName);
            context.setCommand(command);
        }
        catch (GenieJobResolutionException e) {
            tags.add(NO_COMMAND_RESOLVED_ID);
            tags.add(NO_COMMAND_RESOLVED_NAME);
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (ResourceSelectionException t) {
            MetricsUtils.addFailureTagsWithException(tags, (Throwable)((Object)t));
            throw new GenieJobResolutionRuntimeException((Throwable)((Object)t));
        }
        finally {
            this.registry.timer(RESOLVE_COMMAND_TIMER, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveCluster(JobResolutionContext context) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet<Tag> tags = new HashSet<Tag>();
        String jobId = context.getJobId();
        try {
            Command command = context.getCommand().orElseThrow(() -> new IllegalStateException("Command not resolved before attempting to resolve a cluster for job " + jobId));
            Set<Cluster> candidateClusters = context.getCommandClusters().orElseThrow(() -> new IllegalStateException("Command to candidate cluster map not available for job " + jobId)).get(command);
            if (candidateClusters == null || candidateClusters.isEmpty()) {
                throw new IllegalStateException("Command " + command.getId() + " had no candidate clusters for job " + jobId);
            }
            Cluster cluster = null;
            for (ClusterSelector clusterSelector : this.clusterSelectors) {
                HashSet<Tag> selectorTags = new HashSet<Tag>(tags);
                String clusterSelectorClass = this.getProxyObjectClassName(clusterSelector);
                selectorTags.add(Tag.of((String)"class", (String)clusterSelectorClass));
                try {
                    ResourceSelectionResult result = clusterSelector.select(new ClusterSelectionContext(jobId, context.getJobRequest(), context.isApiJob(), command, candidateClusters));
                    Optional selectedClusterOptional = result.getSelectedResource();
                    if (selectedClusterOptional.isPresent()) {
                        cluster = (Cluster)selectedClusterOptional.get();
                        LOG.debug("Successfully selected cluster {} using selector {} for job {} with rationale: {}", new Object[]{cluster.getId(), clusterSelectorClass, jobId, result.getSelectionRationale().orElse(NO_RATIONALE)});
                        selectorTags.add(Tag.of((String)STATUS_FIELD, (String)CLUSTER_SELECTOR_STATUS_SUCCESS));
                        selectorTags.add(Tag.of((String)"clusterId", (String)cluster.getId()));
                        selectorTags.add(Tag.of((String)"clusterName", (String)cluster.getMetadata().getName()));
                        break;
                    }
                    selectorTags.add(Tag.of((String)STATUS_FIELD, (String)CLUSTER_SELECTOR_STATUS_NO_PREFERENCE));
                    selectorTags.add(NO_CLUSTER_RESOLVED_ID);
                    selectorTags.add(NO_CLUSTER_RESOLVED_NAME);
                    LOG.debug("Selector {} returned no preference with rationale: {}", (Object)clusterSelectorClass, (Object)result.getSelectionRationale().orElse(NO_RATIONALE));
                }
                catch (Exception e) {
                    MetricsUtils.addFailureTagsWithException(selectorTags, e);
                    LOG.warn("Cluster selector {} evaluation threw exception for job {}", new Object[]{clusterSelectorClass, jobId, e});
                }
                finally {
                    this.registry.counter(CLUSTER_SELECTOR_COUNTER, selectorTags).increment();
                }
            }
            if (cluster == null) {
                throw new GenieJobResolutionException("No cluster resolved for job " + jobId);
            }
            LOG.debug("Resolved cluster {} for job {}", (Object)cluster.getId(), (Object)jobId);
            context.setCluster(cluster);
            MetricsUtils.addSuccessTags(tags);
            String clusterId = cluster.getId();
            String clusterName = cluster.getMetadata().getName();
            tags.add(Tag.of((String)"clusterId", (String)clusterId));
            tags.add(Tag.of((String)"clusterName", (String)clusterName));
            SpanCustomizer spanCustomizer = context.getSpanCustomizer();
            this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.cluster.id", (Object)clusterId);
            this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.cluster.name", (Object)clusterName);
        }
        catch (GenieJobResolutionException e) {
            tags.add(NO_CLUSTER_RESOLVED_ID);
            tags.add(NO_CLUSTER_RESOLVED_NAME);
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionRuntimeException(t);
        }
        finally {
            this.registry.timer(RESOLVE_CLUSTER_TIMER, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private void resolveApplications(JobResolutionContext context) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet<Tag> tags = new HashSet<Tag>();
        String id = context.getJobId();
        JobRequest jobRequest = context.getJobRequest();
        try {
            String commandId = context.getCommand().orElseThrow(() -> new IllegalStateException("Command hasn't been resolved before applications")).getId();
            LOG.debug("Selecting applications for job {} and command {}", (Object)id, (Object)commandId);
            ArrayList<Application> applications = new ArrayList<Application>();
            if (jobRequest.getCriteria().getApplicationIds().isEmpty()) {
                applications.addAll(this.persistenceService.getApplicationsForCommand(commandId));
            } else {
                for (String applicationId : jobRequest.getCriteria().getApplicationIds()) {
                    applications.add(this.persistenceService.getApplication(applicationId));
                }
            }
            LOG.debug("Resolved applications {} for job {}", (Object)applications.stream().map(CommonResource::getId).reduce((one, two) -> one + "," + two).orElse(NO_ID_FOUND), (Object)id);
            MetricsUtils.addSuccessTags(tags);
            context.setApplications(applications);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionRuntimeException(t);
        }
        finally {
            this.registry.timer(RESOLVE_APPLICATIONS_TIMER, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private void resolveEnvironmentVariables(JobResolutionContext context) {
        Command command = context.getCommand().orElseThrow(() -> new IllegalStateException("Command not resolved before attempting to resolve env variables"));
        Cluster cluster = context.getCluster().orElseThrow(() -> new IllegalStateException("Cluster not resolved before attempting to resolve env variables"));
        String id = context.getJobId();
        JobRequest jobRequest = context.getJobRequest();
        long jobMemory = (Long)context.getComputeResources().orElseThrow(() -> new IllegalStateException("Job memory not resolved before attempting to resolve env variables")).getMemoryMb().orElseThrow(() -> new IllegalStateException("No memory has been resolved before attempting to resolve"));
        HashMap<Object, Object> envVariables = new HashMap<Object, Object>();
        envVariables.put("GENIE_VERSION", VERSION_4);
        envVariables.put("GENIE_CLUSTER_ID", cluster.getId());
        envVariables.put("GENIE_CLUSTER_NAME", cluster.getMetadata().getName());
        envVariables.put("GENIE_CLUSTER_TAGS", this.tagsToString(cluster.getMetadata().getTags()));
        envVariables.put("GENIE_COMMAND_ID", command.getId());
        envVariables.put("GENIE_COMMAND_NAME", command.getMetadata().getName());
        envVariables.put("GENIE_COMMAND_TAGS", this.tagsToString(command.getMetadata().getTags()));
        envVariables.put("GENIE_JOB_ID", id);
        envVariables.put("GENIE_JOB_NAME", jobRequest.getMetadata().getName());
        envVariables.put("GENIE_JOB_MEMORY", String.valueOf(jobMemory));
        envVariables.put("GENIE_JOB_TAGS", this.tagsToString(jobRequest.getMetadata().getTags()));
        envVariables.put("GENIE_JOB_GROUPING", jobRequest.getMetadata().getGrouping().orElse(""));
        envVariables.put("GENIE_JOB_GROUPING_INSTANCE", jobRequest.getMetadata().getGroupingInstance().orElse(""));
        envVariables.put("GENIE_REQUESTED_COMMAND_TAGS", this.tagsToString(jobRequest.getCriteria().getCommandCriterion().getTags()));
        List clusterCriteria = jobRequest.getCriteria().getClusterCriteria();
        ArrayList<CallSite> clusterCriteriaTags = new ArrayList<CallSite>(clusterCriteria.size());
        for (int i = 0; i < clusterCriteria.size(); ++i) {
            Criterion criterion = (Criterion)clusterCriteria.get(i);
            String criteriaTagsString = this.tagsToString(criterion.getTags());
            envVariables.put("GENIE_REQUESTED_CLUSTER_TAGS_" + i, criteriaTagsString);
            clusterCriteriaTags.add((CallSite)((Object)("[" + criteriaTagsString + "]")));
        }
        envVariables.put("GENIE_REQUESTED_CLUSTER_TAGS", "[" + StringUtils.join(clusterCriteriaTags, (char)',') + "]");
        envVariables.put("GENIE_USER", jobRequest.getMetadata().getUser());
        envVariables.put("GENIE_USER_GROUP", jobRequest.getMetadata().getGroup().orElse(""));
        context.setEnvironmentVariables(Collections.unmodifiableMap(envVariables));
    }

    private void resolveTimeout(JobResolutionContext context) {
        JobRequest jobRequest = context.getJobRequest();
        if (jobRequest.getRequestedAgentConfig().getTimeoutRequested().isPresent()) {
            context.setTimeout((Integer)jobRequest.getRequestedAgentConfig().getTimeoutRequested().get());
        } else if (context.isApiJob()) {
            context.setTimeout(604800);
        }
    }

    private void resolveComputeResources(JobResolutionContext context) {
        ComputeResources req = context.getJobRequest().getRequestedJobEnvironment().getRequestedComputeResources();
        ComputeResources command = context.getCommand().orElseThrow(() -> new IllegalStateException("Command hasn't been resolved before compute resources")).getComputeResources();
        ComputeResources defaults = this.jobResolutionProperties.getDefaultComputeResources();
        context.setComputeResources(new ComputeResources.Builder().withCpu(this.resolveComputeResource(() -> ((ComputeResources)req).getCpu(), () -> ((ComputeResources)command).getCpu(), () -> ((ComputeResources)defaults).getCpu(), 1)).withGpu(this.resolveComputeResource(() -> ((ComputeResources)req).getGpu(), () -> ((ComputeResources)command).getGpu(), () -> ((ComputeResources)defaults).getGpu(), 0)).withMemoryMb(this.resolveComputeResource(() -> ((ComputeResources)req).getMemoryMb(), () -> ((ComputeResources)command).getMemoryMb(), () -> ((ComputeResources)defaults).getMemoryMb(), 1500L)).withDiskMb(this.resolveComputeResource(() -> ((ComputeResources)req).getDiskMb(), () -> ((ComputeResources)command).getDiskMb(), () -> ((ComputeResources)defaults).getDiskMb(), 10000L)).withNetworkMbps(this.resolveComputeResource(() -> ((ComputeResources)req).getNetworkMbps(), () -> ((ComputeResources)command).getNetworkMbps(), () -> ((ComputeResources)defaults).getNetworkMbps(), 256L)).build());
    }

    private <T> T resolveComputeResource(Supplier<Optional<T>> requestedResource, Supplier<Optional<T>> commandResource, Supplier<Optional<T>> configuredDefault, T hardCodedDefault) {
        return requestedResource.get().orElse(commandResource.get().orElse(configuredDefault.get().orElse(hardCodedDefault)));
    }

    private void resolveImages(JobResolutionContext context) {
        Map requestImages = context.getJobRequest().getRequestedJobEnvironment().getRequestedImages();
        Map commandImages = context.getCommand().orElseThrow(() -> new IllegalStateException("No command resolved before trying to resolve images")).getImages();
        Map<String, Image> defaultImages = this.jobResolutionProperties.getDefaultImages();
        HashMap<String, Image> resolvedImages = new HashMap<String, Image>(defaultImages);
        for (Map.Entry entry : commandImages.entrySet()) {
            resolvedImages.merge((String)entry.getKey(), (Image)entry.getValue(), this::mergeImages);
        }
        for (Map.Entry entry : requestImages.entrySet()) {
            resolvedImages.merge((String)entry.getKey(), (Image)entry.getValue(), this::mergeImages);
        }
        context.setImages(resolvedImages);
    }

    private void resolveArchiveLocation(JobResolutionContext context) {
        context.setArchiveLocation(this.defaultArchiveLocation + context.getJobId());
    }

    private void resolveJobDirectory(JobResolutionContext context) {
        context.setJobDirectory(context.getJobRequest().getRequestedAgentConfig().getRequestedJobDirectoryLocation().orElse(this.defaultJobDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Command, List<Criterion>> generateClusterCriteriaPermutations(Set<Command> commands, JobRequest jobRequest) {
        long start = System.nanoTime();
        try {
            HashMap mapBuilder = new HashMap();
            for (Command command : commands) {
                ArrayList<Criterion> listBuilder = new ArrayList<Criterion>();
                for (Criterion commandClusterCriterion : command.getClusterCriteria()) {
                    for (Criterion jobClusterCriterion : jobRequest.getCriteria().getClusterCriteria()) {
                        try {
                            listBuilder.add(this.mergeCriteria(commandClusterCriterion, jobClusterCriterion));
                        }
                        catch (IllegalArgumentException e) {
                            LOG.debug("Unable to merge command cluster criterion {} and job cluster criterion {}. Skipping.", new Object[]{commandClusterCriterion, jobClusterCriterion, e});
                        }
                    }
                }
                mapBuilder.put(command, Collections.unmodifiableList(listBuilder));
            }
            Map map = Collections.unmodifiableMap(mapBuilder);
            return map;
        }
        finally {
            this.registry.timer(GENERATE_CRITERIA_PERMUTATIONS_TIMER, new String[0]).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Set<Criterion> flattenClusterCriteriaPermutations(Map<Command, List<Criterion>> commandCriteriaMap) {
        return commandCriteriaMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean clusterMatchesCriterion(Cluster cluster, Criterion criterion) {
        ClusterMetadata metadata = cluster.getMetadata();
        return criterion.getId().map(id -> cluster.getId().equals(id)).orElse(true) != false && criterion.getName().map(name -> metadata.getName().equals(name)).orElse(true) != false && criterion.getVersion().map(version -> metadata.getVersion().equals(version)).orElse(true) != false && criterion.getStatus().map(status -> metadata.getStatus().name().equals(status)).orElse(true) != false && metadata.getTags().containsAll(criterion.getTags());
    }

    private Map<Command, Set<Cluster>> generateCommandClustersMap(Map<Command, List<Criterion>> commandClusterCriteria, Set<Cluster> candidateClusters) {
        HashMap matrixBuilder = new HashMap();
        block0: for (Map.Entry<Command, List<Criterion>> entry : commandClusterCriteria.entrySet()) {
            Command command = entry.getKey();
            HashSet<Cluster> matchedClustersBuilder = new HashSet<Cluster>();
            for (Criterion criterion : entry.getValue()) {
                for (Cluster candidateCluster : candidateClusters) {
                    if (!this.clusterMatchesCriterion(candidateCluster, criterion)) continue;
                    LOG.debug("Cluster {} matched criterion {} for command {}", new Object[]{candidateCluster.getId(), criterion, command.getId()});
                    matchedClustersBuilder.add(candidateCluster);
                }
                Set matchedClusters = Collections.unmodifiableSet(matchedClustersBuilder);
                if (matchedClusters.isEmpty()) continue;
                matrixBuilder.put(command, matchedClusters);
                LOG.debug("For command {} matched clusters {}", (Object)command, matchedClusters);
                continue block0;
            }
        }
        Map<Command, Set<Cluster>> matrix = Collections.unmodifiableMap(matrixBuilder);
        LOG.debug("Complete command -> clusters matrix: {}", matrix);
        return matrix;
    }

    private Criterion mergeCriteria(Criterion one, Criterion two) throws IllegalArgumentException {
        Criterion.Builder builder = new Criterion.Builder();
        builder.withId(this.mergeCriteriaStrings(one.getId().orElse(null), two.getId().orElse(null), ID_FIELD));
        builder.withName(this.mergeCriteriaStrings(one.getName().orElse(null), two.getName().orElse(null), NAME_FIELD));
        builder.withStatus(this.mergeCriteriaStrings(one.getStatus().orElse(null), two.getStatus().orElse(null), STATUS_FIELD));
        builder.withVersion(this.mergeCriteriaStrings(one.getVersion().orElse(null), two.getVersion().orElse(null), VERSION_FIELD));
        HashSet tags = new HashSet(one.getTags());
        tags.addAll(two.getTags());
        builder.withTags(tags);
        return builder.build();
    }

    private String mergeCriteriaStrings(@Nullable String one, @Nullable String two, String fieldName) throws IllegalArgumentException {
        if (StringUtils.equals((CharSequence)one, (CharSequence)two)) {
            return one;
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        throw new IllegalArgumentException(fieldName + "'s were both present but not equal");
    }

    private Image mergeImages(Image secondary, Image primary) {
        return new Image.Builder().withName(primary.getName().orElse(secondary.getName().orElse(null))).withTag(primary.getTag().orElse(secondary.getTag().orElse(null))).withArguments(primary.getArguments().isEmpty() ? secondary.getArguments() : primary.getArguments()).build();
    }

    private String tagsToString(Set<String> tags) {
        ArrayList<String> sortedTags = new ArrayList<String>(tags);
        sortedTags.sort(Comparator.naturalOrder());
        String joinedString = StringUtils.join(sortedTags, (char)',');
        return RegExUtils.replaceAll((String)RegExUtils.replaceAll((String)joinedString, (String)"'", (String)"\\'"), (String)"\"", (String)"\\\"");
    }

    private String getProxyObjectClassName(Object possibleProxyObject) {
        Class targetClass;
        String className = possibleProxyObject instanceof TargetClassAware ? ((targetClass = ((TargetClassAware)possibleProxyObject).getTargetClass()) != null ? targetClass.getCanonicalName() : possibleProxyObject.getClass().getCanonicalName()) : possibleProxyObject.getClass().getCanonicalName();
        return className;
    }

    private void tagSpanWithJobMetadata(JobResolutionContext context) {
        SpanCustomizer spanCustomizer = this.tracer.currentSpanCustomizer();
        this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.id", (Object)context.getJobId());
        JobMetadata jobMetadata = context.getJobRequest().getMetadata();
        this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.name", (Object)jobMetadata.getName());
        this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.user", (Object)jobMetadata.getUser());
    }

    static class JobResolutionContext {
        private final String jobId;
        private final JobRequest jobRequest;
        private final boolean apiJob;
        private final SpanCustomizer spanCustomizer;
        private Command command;
        private Cluster cluster;
        private List<Application> applications;
        private ComputeResources computeResources;
        private Map<String, String> environmentVariables;
        private Integer timeout;
        private String archiveLocation;
        private File jobDirectory;
        private Map<Command, Set<Cluster>> commandClusters;
        private Map<String, Image> images;

        Optional<Command> getCommand() {
            return Optional.ofNullable(this.command);
        }

        Optional<Cluster> getCluster() {
            return Optional.ofNullable(this.cluster);
        }

        Optional<List<Application>> getApplications() {
            return Optional.ofNullable(this.applications);
        }

        Optional<ComputeResources> getComputeResources() {
            return Optional.ofNullable(this.computeResources);
        }

        Optional<Map<String, String>> getEnvironmentVariables() {
            return Optional.ofNullable(this.environmentVariables);
        }

        Optional<Integer> getTimeout() {
            return Optional.ofNullable(this.timeout);
        }

        Optional<String> getArchiveLocation() {
            return Optional.ofNullable(this.archiveLocation);
        }

        Optional<File> getJobDirectory() {
            return Optional.ofNullable(this.jobDirectory);
        }

        Optional<Map<Command, Set<Cluster>>> getCommandClusters() {
            return Optional.ofNullable(this.commandClusters);
        }

        Optional<Map<String, Image>> getImages() {
            return Optional.ofNullable(this.images);
        }

        ResolvedJob build() {
            if (this.command == null) {
                throw new IllegalStateException("Command was never resolved for job " + this.jobId);
            }
            if (this.cluster == null) {
                throw new IllegalStateException("Cluster was never resolved for job " + this.jobId);
            }
            if (this.applications == null) {
                throw new IllegalStateException("Applications were never resolved for job " + this.jobId);
            }
            if (this.computeResources == null) {
                throw new IllegalStateException("Compute resources were never resolved for job " + this.jobId);
            }
            if (this.images == null) {
                throw new IllegalStateException("Images were never resolved for job " + this.jobId);
            }
            if (this.environmentVariables == null) {
                throw new IllegalStateException("Environment variables were never resolved for job " + this.jobId);
            }
            if (this.archiveLocation == null) {
                throw new IllegalStateException("Archive location was never resolved for job " + this.jobId);
            }
            if (this.jobDirectory == null) {
                throw new IllegalStateException("Job directory was never resolved for job " + this.jobId);
            }
            JobSpecification jobSpecification = new JobSpecification(this.command.getExecutable(), this.jobRequest.getCommandArgs(), new JobSpecification.ExecutionResource(this.jobId, this.jobRequest.getResources()), new JobSpecification.ExecutionResource(this.cluster.getId(), this.cluster.getResources()), new JobSpecification.ExecutionResource(this.command.getId(), this.command.getResources()), this.applications.stream().map(application -> new JobSpecification.ExecutionResource(application.getId(), application.getResources())).collect(Collectors.toList()), this.environmentVariables, this.jobRequest.getRequestedAgentConfig().isInteractive(), this.jobDirectory, this.archiveLocation, this.timeout);
            JobEnvironment jobEnvironment = new JobEnvironment.Builder().withComputeResources(this.computeResources).withEnvironmentVariables(this.environmentVariables).withImages(this.images).build();
            return new ResolvedJob(jobSpecification, jobEnvironment, this.jobRequest.getMetadata());
        }

        public JobResolutionContext(String jobId, JobRequest jobRequest, boolean apiJob, SpanCustomizer spanCustomizer) {
            this.jobId = jobId;
            this.jobRequest = jobRequest;
            this.apiJob = apiJob;
            this.spanCustomizer = spanCustomizer;
        }

        public String getJobId() {
            return this.jobId;
        }

        public JobRequest getJobRequest() {
            return this.jobRequest;
        }

        public boolean isApiJob() {
            return this.apiJob;
        }

        public SpanCustomizer getSpanCustomizer() {
            return this.spanCustomizer;
        }

        public void setCommand(Command command) {
            this.command = command;
        }

        public void setCluster(Cluster cluster) {
            this.cluster = cluster;
        }

        public void setApplications(List<Application> applications) {
            this.applications = applications;
        }

        public void setComputeResources(ComputeResources computeResources) {
            this.computeResources = computeResources;
        }

        public void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public void setArchiveLocation(String archiveLocation) {
            this.archiveLocation = archiveLocation;
        }

        public void setJobDirectory(File jobDirectory) {
            this.jobDirectory = jobDirectory;
        }

        public void setCommandClusters(Map<Command, Set<Cluster>> commandClusters) {
            this.commandClusters = commandClusters;
        }

        public void setImages(Map<String, Image> images) {
            this.images = images;
        }

        public String toString() {
            return "JobResolverServiceImpl.JobResolutionContext(jobId=" + this.jobId + ", jobRequest=" + this.jobRequest + ", apiJob=" + this.apiJob + ", spanCustomizer=" + this.spanCustomizer + ", command=" + this.command + ", cluster=" + this.cluster + ", applications=" + this.applications + ", computeResources=" + this.computeResources + ", environmentVariables=" + this.environmentVariables + ", timeout=" + this.timeout + ", archiveLocation=" + this.archiveLocation + ", jobDirectory=" + this.jobDirectory + ", commandClusters=" + this.commandClusters + ", images=" + this.images + ")";
        }
    }
}

