/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.netflix.genie.web.exceptions.checked.AttachmentTooLargeException;
import com.netflix.genie.web.exceptions.checked.IllegalAttachmentFileNameException;
import com.netflix.genie.web.exceptions.checked.SaveAttachmentException;
import com.netflix.genie.web.properties.AttachmentServiceProperties;
import com.netflix.genie.web.services.AttachmentService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.springframework.core.io.Resource;

public class LocalFileSystemAttachmentServiceImpl
implements AttachmentService {
    private final Path attachmentsDirectoryPath;
    private final AttachmentServiceProperties attachmentServiceProperties;

    public LocalFileSystemAttachmentServiceImpl(AttachmentServiceProperties attachmentServiceProperties) throws IOException {
        this.attachmentServiceProperties = attachmentServiceProperties;
        this.attachmentsDirectoryPath = Paths.get(attachmentServiceProperties.getLocationPrefix());
        Files.createDirectories(this.attachmentsDirectoryPath, new FileAttribute[0]);
    }

    @Override
    public Set<URI> saveAttachments(@Nullable String jobId, Set<Resource> attachments) throws SaveAttachmentException {
        if (attachments.isEmpty()) {
            return Sets.newHashSet();
        }
        Path attachmentsBasePath = this.attachmentsDirectoryPath.resolve(UUID.randomUUID().toString());
        try {
            Files.createDirectories(attachmentsBasePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SaveAttachmentException("Failed to create directory for attachments: " + e.getMessage(), e);
        }
        long totalSize = 0L;
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Resource attachment : attachments) {
            try {
                InputStream inputStream = attachment.getInputStream();
                try {
                    long attachmentSize = attachment.contentLength();
                    String filename = attachment.getFilename();
                    if (filename != null) {
                        String baseCanonicalPath;
                        if (filename.contains("/") || filename.contains("\\") || filename.equals(".") || filename.contains("..")) {
                            throw new IllegalAttachmentFileNameException("Attachment filename " + filename + " is illegal. Filenames should not be ., or contain .., /, \\.");
                        }
                        String attachmentCanonicalPath = this.createTempFile(String.valueOf(attachmentsBasePath), filename).getCanonicalPath();
                        if (!attachmentCanonicalPath.startsWith(baseCanonicalPath = new File(String.valueOf(attachmentsBasePath)).getCanonicalPath()) || attachmentCanonicalPath.equals(baseCanonicalPath)) {
                            throw new IllegalAttachmentFileNameException("Attachment filename " + filename + " is illegal. Filenames should not be a relative path.");
                        }
                    }
                    if (attachmentSize > this.attachmentServiceProperties.getMaxSize().toBytes()) {
                        throw new AttachmentTooLargeException("Attachment is too large: " + filename);
                    }
                    if ((totalSize += attachmentSize) > this.attachmentServiceProperties.getMaxTotalSize().toBytes()) {
                        throw new AttachmentTooLargeException("Attachments total size is too large");
                    }
                    Path attachmentPath = attachmentsBasePath.resolve(filename != null ? filename : UUID.randomUUID().toString());
                    Files.copy(inputStream, attachmentPath, new CopyOption[0]);
                    setBuilder.add((Object)attachmentPath.toUri());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new SaveAttachmentException("Failed to save attachment: " + e.getMessage(), e);
            }
        }
        return setBuilder.build();
    }

    File createTempFile(String attachmentsBasePath, String filename) {
        return new File(attachmentsBasePath, filename);
    }
}

