/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import com.google.common.collect.Sets;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Set;

public final class MetricsUtils {
    private static final Tag SUCCESS_STATUS_TAG = Tag.of((String)"status", (String)"success");
    private static final Tag FAILURE_STATUS_TAG = Tag.of((String)"status", (String)"failure");

    private MetricsUtils() {
    }

    public static Set<Tag> newSuccessTagsSet() {
        HashSet tags = Sets.newHashSet();
        MetricsUtils.addSuccessTags(tags);
        return tags;
    }

    public static void addSuccessTags(Set<Tag> tags) {
        tags.add(SUCCESS_STATUS_TAG);
    }

    public static Set<Tag> newFailureTagsSetForException(Throwable t) {
        HashSet tags = Sets.newHashSet();
        MetricsUtils.addFailureTagsWithException(tags, t);
        return tags;
    }

    public static void addFailureTagsWithException(Set<Tag> tags, Throwable throwable) {
        tags.add(FAILURE_STATUS_TAG);
        tags.add(Tag.of((String)"exceptionClass", (String)throwable.getClass().getCanonicalName()));
    }
}

