/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.launchers.dtos;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.NonNull;

public class TitusBatchJobRequest {
    @NotNull
    @NonNull
    private Owner owner;
    @NotNull
    @NonNull
    private Map<String, String> attributes;
    @NotNull
    @NonNull
    private Container container;
    @NotNull
    @NonNull
    private Batch batch;
    @NotNull
    @NonNull
    private DisruptionBudget disruptionBudget;
    @NotNull
    @NonNull
    private String applicationName;
    @NotNull
    @NonNull
    private String capacityGroup;
    @NotNull
    @NonNull
    private JobGroupInfo jobGroupInfo;
    @Nullable
    private NetworkConfiguration networkConfiguration;

    TitusBatchJobRequest(@NotNull @NonNull Owner owner, @NotNull @NonNull Map<String, String> attributes, @NotNull @NonNull Container container, @NotNull @NonNull Batch batch, @NotNull @NonNull DisruptionBudget disruptionBudget, @NotNull @NonNull String applicationName, @NotNull @NonNull String capacityGroup, @NotNull @NonNull JobGroupInfo jobGroupInfo, @Nullable NetworkConfiguration networkConfiguration) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (disruptionBudget == null) {
            throw new NullPointerException("disruptionBudget is marked non-null but is null");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked non-null but is null");
        }
        if (capacityGroup == null) {
            throw new NullPointerException("capacityGroup is marked non-null but is null");
        }
        if (jobGroupInfo == null) {
            throw new NullPointerException("jobGroupInfo is marked non-null but is null");
        }
        this.owner = owner;
        this.attributes = attributes;
        this.container = container;
        this.batch = batch;
        this.disruptionBudget = disruptionBudget;
        this.applicationName = applicationName;
        this.capacityGroup = capacityGroup;
        this.jobGroupInfo = jobGroupInfo;
        this.networkConfiguration = networkConfiguration;
    }

    public static TitusBatchJobRequestBuilder builder() {
        return new TitusBatchJobRequestBuilder();
    }

    @NotNull
    @NonNull
    public Owner getOwner() {
        return this.owner;
    }

    @NotNull
    @NonNull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    @NonNull
    public Container getContainer() {
        return this.container;
    }

    @NotNull
    @NonNull
    public Batch getBatch() {
        return this.batch;
    }

    @NotNull
    @NonNull
    public DisruptionBudget getDisruptionBudget() {
        return this.disruptionBudget;
    }

    @NotNull
    @NonNull
    public String getApplicationName() {
        return this.applicationName;
    }

    @NotNull
    @NonNull
    public String getCapacityGroup() {
        return this.capacityGroup;
    }

    @NotNull
    @NonNull
    public JobGroupInfo getJobGroupInfo() {
        return this.jobGroupInfo;
    }

    @Nullable
    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public void setOwner(@NotNull @NonNull Owner owner) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        this.owner = owner;
    }

    public void setAttributes(@NotNull @NonNull Map<String, String> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.attributes = attributes;
    }

    public void setContainer(@NotNull @NonNull Container container) {
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        this.container = container;
    }

    public void setBatch(@NotNull @NonNull Batch batch) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        this.batch = batch;
    }

    public void setDisruptionBudget(@NotNull @NonNull DisruptionBudget disruptionBudget) {
        if (disruptionBudget == null) {
            throw new NullPointerException("disruptionBudget is marked non-null but is null");
        }
        this.disruptionBudget = disruptionBudget;
    }

    public void setApplicationName(@NotNull @NonNull String applicationName) {
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked non-null but is null");
        }
        this.applicationName = applicationName;
    }

    public void setCapacityGroup(@NotNull @NonNull String capacityGroup) {
        if (capacityGroup == null) {
            throw new NullPointerException("capacityGroup is marked non-null but is null");
        }
        this.capacityGroup = capacityGroup;
    }

    public void setJobGroupInfo(@NotNull @NonNull JobGroupInfo jobGroupInfo) {
        if (jobGroupInfo == null) {
            throw new NullPointerException("jobGroupInfo is marked non-null but is null");
        }
        this.jobGroupInfo = jobGroupInfo;
    }

    public void setNetworkConfiguration(@Nullable NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TitusBatchJobRequest)) {
            return false;
        }
        TitusBatchJobRequest other = (TitusBatchJobRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Owner this$owner = this.getOwner();
        Owner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Container this$container = this.getContainer();
        Container other$container = other.getContainer();
        if (this$container == null ? other$container != null : !((Object)this$container).equals(other$container)) {
            return false;
        }
        Batch this$batch = this.getBatch();
        Batch other$batch = other.getBatch();
        if (this$batch == null ? other$batch != null : !((Object)this$batch).equals(other$batch)) {
            return false;
        }
        DisruptionBudget this$disruptionBudget = this.getDisruptionBudget();
        DisruptionBudget other$disruptionBudget = other.getDisruptionBudget();
        if (this$disruptionBudget == null ? other$disruptionBudget != null : !((Object)this$disruptionBudget).equals(other$disruptionBudget)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$capacityGroup = this.getCapacityGroup();
        String other$capacityGroup = other.getCapacityGroup();
        if (this$capacityGroup == null ? other$capacityGroup != null : !this$capacityGroup.equals(other$capacityGroup)) {
            return false;
        }
        JobGroupInfo this$jobGroupInfo = this.getJobGroupInfo();
        JobGroupInfo other$jobGroupInfo = other.getJobGroupInfo();
        if (this$jobGroupInfo == null ? other$jobGroupInfo != null : !((Object)this$jobGroupInfo).equals(other$jobGroupInfo)) {
            return false;
        }
        NetworkConfiguration this$networkConfiguration = this.getNetworkConfiguration();
        NetworkConfiguration other$networkConfiguration = other.getNetworkConfiguration();
        return !(this$networkConfiguration == null ? other$networkConfiguration != null : !((Object)this$networkConfiguration).equals(other$networkConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TitusBatchJobRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Owner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Container $container = this.getContainer();
        result = result * 59 + ($container == null ? 43 : ((Object)$container).hashCode());
        Batch $batch = this.getBatch();
        result = result * 59 + ($batch == null ? 43 : ((Object)$batch).hashCode());
        DisruptionBudget $disruptionBudget = this.getDisruptionBudget();
        result = result * 59 + ($disruptionBudget == null ? 43 : ((Object)$disruptionBudget).hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $capacityGroup = this.getCapacityGroup();
        result = result * 59 + ($capacityGroup == null ? 43 : $capacityGroup.hashCode());
        JobGroupInfo $jobGroupInfo = this.getJobGroupInfo();
        result = result * 59 + ($jobGroupInfo == null ? 43 : ((Object)$jobGroupInfo).hashCode());
        NetworkConfiguration $networkConfiguration = this.getNetworkConfiguration();
        result = result * 59 + ($networkConfiguration == null ? 43 : ((Object)$networkConfiguration).hashCode());
        return result;
    }

    public String toString() {
        return "TitusBatchJobRequest(owner=" + this.getOwner() + ", attributes=" + this.getAttributes() + ", container=" + this.getContainer() + ", batch=" + this.getBatch() + ", disruptionBudget=" + this.getDisruptionBudget() + ", applicationName=" + this.getApplicationName() + ", capacityGroup=" + this.getCapacityGroup() + ", jobGroupInfo=" + this.getJobGroupInfo() + ", networkConfiguration=" + this.getNetworkConfiguration() + ")";
    }

    public static class Owner {
        @NotNull
        @NonNull
        private String teamEmail;

        Owner(@NotNull @NonNull String teamEmail) {
            if (teamEmail == null) {
                throw new NullPointerException("teamEmail is marked non-null but is null");
            }
            this.teamEmail = teamEmail;
        }

        public static OwnerBuilder builder() {
            return new OwnerBuilder();
        }

        @NotNull
        @NonNull
        public String getTeamEmail() {
            return this.teamEmail;
        }

        public void setTeamEmail(@NotNull @NonNull String teamEmail) {
            if (teamEmail == null) {
                throw new NullPointerException("teamEmail is marked non-null but is null");
            }
            this.teamEmail = teamEmail;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner other = (Owner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$teamEmail = this.getTeamEmail();
            String other$teamEmail = other.getTeamEmail();
            return !(this$teamEmail == null ? other$teamEmail != null : !this$teamEmail.equals(other$teamEmail));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Owner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $teamEmail = this.getTeamEmail();
            result = result * 59 + ($teamEmail == null ? 43 : $teamEmail.hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.Owner(teamEmail=" + this.getTeamEmail() + ")";
        }

        public static class OwnerBuilder {
            private String teamEmail;

            OwnerBuilder() {
            }

            public OwnerBuilder teamEmail(@NotNull @NonNull String teamEmail) {
                if (teamEmail == null) {
                    throw new NullPointerException("teamEmail is marked non-null but is null");
                }
                this.teamEmail = teamEmail;
                return this;
            }

            public Owner build() {
                return new Owner(this.teamEmail);
            }

            public String toString() {
                return "TitusBatchJobRequest.Owner.OwnerBuilder(teamEmail=" + this.teamEmail + ")";
            }
        }
    }

    public static class Container {
        @NotNull.List(value={@NotNull, @NotNull})
        private @NotNull.List(value={@NotNull, @NotNull}) Resources resources;
        @NotNull
        @NonNull
        private SecurityProfile securityProfile;
        @NotNull
        @NonNull
        private Image image;
        @NotNull
        @NonNull
        private List<String> entryPoint;
        @NotNull
        @NonNull
        private List<String> command;
        @NotNull
        @NonNull
        private Map<String, String> env;
        @NotNull
        @NonNull
        private Map<String, String> attributes;
        @Nullable
        private ContainerConstraints softConstraints;
        @Nullable
        private ContainerConstraints hardConstraints;

        Container(@NotNull.List(value={@NotNull, @NotNull}) @NotNull.List(value={@NotNull, @NotNull}) Resources resources, @NotNull @NonNull SecurityProfile securityProfile, @NotNull @NonNull Image image, @NotNull @NonNull List<String> entryPoint, @NotNull @NonNull List<String> command, @NotNull @NonNull Map<String, String> env, @NotNull @NonNull Map<String, String> attributes, @Nullable ContainerConstraints softConstraints, @Nullable ContainerConstraints hardConstraints) {
            if (securityProfile == null) {
                throw new NullPointerException("securityProfile is marked non-null but is null");
            }
            if (image == null) {
                throw new NullPointerException("image is marked non-null but is null");
            }
            if (entryPoint == null) {
                throw new NullPointerException("entryPoint is marked non-null but is null");
            }
            if (command == null) {
                throw new NullPointerException("command is marked non-null but is null");
            }
            if (env == null) {
                throw new NullPointerException("env is marked non-null but is null");
            }
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            this.resources = resources;
            this.securityProfile = securityProfile;
            this.image = image;
            this.entryPoint = entryPoint;
            this.command = command;
            this.env = env;
            this.attributes = attributes;
            this.softConstraints = softConstraints;
            this.hardConstraints = hardConstraints;
        }

        public static ContainerBuilder builder() {
            return new ContainerBuilder();
        }

        @NotNull.List(value={@NotNull, @NotNull})
        public @NotNull.List(value={@NotNull, @NotNull}) Resources getResources() {
            return this.resources;
        }

        @NotNull
        @NonNull
        public SecurityProfile getSecurityProfile() {
            return this.securityProfile;
        }

        @NotNull
        @NonNull
        public Image getImage() {
            return this.image;
        }

        @NotNull
        @NonNull
        public List<String> getEntryPoint() {
            return this.entryPoint;
        }

        @NotNull
        @NonNull
        public List<String> getCommand() {
            return this.command;
        }

        @NotNull
        @NonNull
        public Map<String, String> getEnv() {
            return this.env;
        }

        @NotNull
        @NonNull
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Nullable
        public ContainerConstraints getSoftConstraints() {
            return this.softConstraints;
        }

        @Nullable
        public ContainerConstraints getHardConstraints() {
            return this.hardConstraints;
        }

        public void setResources(@NotNull.List(value={@NotNull, @NotNull}) @NotNull.List(value={@NotNull, @NotNull}) Resources resources) {
            this.resources = resources;
        }

        public void setSecurityProfile(@NotNull @NonNull SecurityProfile securityProfile) {
            if (securityProfile == null) {
                throw new NullPointerException("securityProfile is marked non-null but is null");
            }
            this.securityProfile = securityProfile;
        }

        public void setImage(@NotNull @NonNull Image image) {
            if (image == null) {
                throw new NullPointerException("image is marked non-null but is null");
            }
            this.image = image;
        }

        public void setEntryPoint(@NotNull @NonNull List<String> entryPoint) {
            if (entryPoint == null) {
                throw new NullPointerException("entryPoint is marked non-null but is null");
            }
            this.entryPoint = entryPoint;
        }

        public void setCommand(@NotNull @NonNull List<String> command) {
            if (command == null) {
                throw new NullPointerException("command is marked non-null but is null");
            }
            this.command = command;
        }

        public void setEnv(@NotNull @NonNull Map<String, String> env) {
            if (env == null) {
                throw new NullPointerException("env is marked non-null but is null");
            }
            this.env = env;
        }

        public void setAttributes(@NotNull @NonNull Map<String, String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            this.attributes = attributes;
        }

        public void setSoftConstraints(@Nullable ContainerConstraints softConstraints) {
            this.softConstraints = softConstraints;
        }

        public void setHardConstraints(@Nullable ContainerConstraints hardConstraints) {
            this.hardConstraints = hardConstraints;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Container)) {
                return false;
            }
            Container other = (Container)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Resources this$resources = this.getResources();
            Resources other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            SecurityProfile this$securityProfile = this.getSecurityProfile();
            SecurityProfile other$securityProfile = other.getSecurityProfile();
            if (this$securityProfile == null ? other$securityProfile != null : !((Object)this$securityProfile).equals(other$securityProfile)) {
                return false;
            }
            Image this$image = this.getImage();
            Image other$image = other.getImage();
            if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
                return false;
            }
            List<String> this$entryPoint = this.getEntryPoint();
            List<String> other$entryPoint = other.getEntryPoint();
            if (this$entryPoint == null ? other$entryPoint != null : !((Object)this$entryPoint).equals(other$entryPoint)) {
                return false;
            }
            List<String> this$command = this.getCommand();
            List<String> other$command = other.getCommand();
            if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
                return false;
            }
            Map<String, String> this$env = this.getEnv();
            Map<String, String> other$env = other.getEnv();
            if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            ContainerConstraints this$softConstraints = this.getSoftConstraints();
            ContainerConstraints other$softConstraints = other.getSoftConstraints();
            if (this$softConstraints == null ? other$softConstraints != null : !((Object)this$softConstraints).equals(other$softConstraints)) {
                return false;
            }
            ContainerConstraints this$hardConstraints = this.getHardConstraints();
            ContainerConstraints other$hardConstraints = other.getHardConstraints();
            return !(this$hardConstraints == null ? other$hardConstraints != null : !((Object)this$hardConstraints).equals(other$hardConstraints));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Container;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Resources $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            SecurityProfile $securityProfile = this.getSecurityProfile();
            result = result * 59 + ($securityProfile == null ? 43 : ((Object)$securityProfile).hashCode());
            Image $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
            List<String> $entryPoint = this.getEntryPoint();
            result = result * 59 + ($entryPoint == null ? 43 : ((Object)$entryPoint).hashCode());
            List<String> $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
            Map<String, String> $env = this.getEnv();
            result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            ContainerConstraints $softConstraints = this.getSoftConstraints();
            result = result * 59 + ($softConstraints == null ? 43 : ((Object)$softConstraints).hashCode());
            ContainerConstraints $hardConstraints = this.getHardConstraints();
            result = result * 59 + ($hardConstraints == null ? 43 : ((Object)$hardConstraints).hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.Container(resources=" + this.getResources() + ", securityProfile=" + this.getSecurityProfile() + ", image=" + this.getImage() + ", entryPoint=" + this.getEntryPoint() + ", command=" + this.getCommand() + ", env=" + this.getEnv() + ", attributes=" + this.getAttributes() + ", softConstraints=" + this.getSoftConstraints() + ", hardConstraints=" + this.getHardConstraints() + ")";
        }

        public static class ContainerBuilder {
            private Resources resources;
            private SecurityProfile securityProfile;
            private Image image;
            private List<String> entryPoint;
            private List<String> command;
            private Map<String, String> env;
            private Map<String, String> attributes;
            private ContainerConstraints softConstraints;
            private ContainerConstraints hardConstraints;

            ContainerBuilder() {
            }

            public ContainerBuilder resources(@NotNull.List(value={@NotNull, @NotNull}) @NotNull.List(value={@NotNull, @NotNull}) Resources resources) {
                this.resources = resources;
                return this;
            }

            public ContainerBuilder securityProfile(@NotNull @NonNull SecurityProfile securityProfile) {
                if (securityProfile == null) {
                    throw new NullPointerException("securityProfile is marked non-null but is null");
                }
                this.securityProfile = securityProfile;
                return this;
            }

            public ContainerBuilder image(@NotNull @NonNull Image image) {
                if (image == null) {
                    throw new NullPointerException("image is marked non-null but is null");
                }
                this.image = image;
                return this;
            }

            public ContainerBuilder entryPoint(@NotNull @NonNull List<String> entryPoint) {
                if (entryPoint == null) {
                    throw new NullPointerException("entryPoint is marked non-null but is null");
                }
                this.entryPoint = entryPoint;
                return this;
            }

            public ContainerBuilder command(@NotNull @NonNull List<String> command) {
                if (command == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                this.command = command;
                return this;
            }

            public ContainerBuilder env(@NotNull @NonNull Map<String, String> env) {
                if (env == null) {
                    throw new NullPointerException("env is marked non-null but is null");
                }
                this.env = env;
                return this;
            }

            public ContainerBuilder attributes(@NotNull @NonNull Map<String, String> attributes) {
                if (attributes == null) {
                    throw new NullPointerException("attributes is marked non-null but is null");
                }
                this.attributes = attributes;
                return this;
            }

            public ContainerBuilder softConstraints(@Nullable ContainerConstraints softConstraints) {
                this.softConstraints = softConstraints;
                return this;
            }

            public ContainerBuilder hardConstraints(@Nullable ContainerConstraints hardConstraints) {
                this.hardConstraints = hardConstraints;
                return this;
            }

            public Container build() {
                return new Container(this.resources, this.securityProfile, this.image, this.entryPoint, this.command, this.env, this.attributes, this.softConstraints, this.hardConstraints);
            }

            public String toString() {
                return "TitusBatchJobRequest.Container.ContainerBuilder(resources=" + this.resources + ", securityProfile=" + this.securityProfile + ", image=" + this.image + ", entryPoint=" + this.entryPoint + ", command=" + this.command + ", env=" + this.env + ", attributes=" + this.attributes + ", softConstraints=" + this.softConstraints + ", hardConstraints=" + this.hardConstraints + ")";
            }
        }
    }

    public static class Batch {
        @NotNull
        @NonNull
        private RetryPolicy retryPolicy;
        @Min(value=1L)
        private @Min(value=1L) int size;
        private long runtimeLimitSec;

        Batch(@NotNull @NonNull RetryPolicy retryPolicy, int size, long runtimeLimitSec) {
            if (retryPolicy == null) {
                throw new NullPointerException("retryPolicy is marked non-null but is null");
            }
            this.retryPolicy = retryPolicy;
            this.size = size;
            this.runtimeLimitSec = runtimeLimitSec;
        }

        public static BatchBuilder builder() {
            return new BatchBuilder();
        }

        @NotNull
        @NonNull
        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public int getSize() {
            return this.size;
        }

        public long getRuntimeLimitSec() {
            return this.runtimeLimitSec;
        }

        public void setRetryPolicy(@NotNull @NonNull RetryPolicy retryPolicy) {
            if (retryPolicy == null) {
                throw new NullPointerException("retryPolicy is marked non-null but is null");
            }
            this.retryPolicy = retryPolicy;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setRuntimeLimitSec(long runtimeLimitSec) {
            this.runtimeLimitSec = runtimeLimitSec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Batch)) {
                return false;
            }
            Batch other = (Batch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getRuntimeLimitSec() != other.getRuntimeLimitSec()) {
                return false;
            }
            RetryPolicy this$retryPolicy = this.getRetryPolicy();
            RetryPolicy other$retryPolicy = other.getRetryPolicy();
            return !(this$retryPolicy == null ? other$retryPolicy != null : !((Object)this$retryPolicy).equals(other$retryPolicy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Batch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $runtimeLimitSec = this.getRuntimeLimitSec();
            result = result * 59 + (int)($runtimeLimitSec >>> 32 ^ $runtimeLimitSec);
            RetryPolicy $retryPolicy = this.getRetryPolicy();
            result = result * 59 + ($retryPolicy == null ? 43 : ((Object)$retryPolicy).hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.Batch(retryPolicy=" + this.getRetryPolicy() + ", size=" + this.getSize() + ", runtimeLimitSec=" + this.getRuntimeLimitSec() + ")";
        }

        public static class BatchBuilder {
            private RetryPolicy retryPolicy;
            private int size;
            private long runtimeLimitSec;

            BatchBuilder() {
            }

            public BatchBuilder retryPolicy(@NotNull @NonNull RetryPolicy retryPolicy) {
                if (retryPolicy == null) {
                    throw new NullPointerException("retryPolicy is marked non-null but is null");
                }
                this.retryPolicy = retryPolicy;
                return this;
            }

            public BatchBuilder size(int size) {
                this.size = size;
                return this;
            }

            public BatchBuilder runtimeLimitSec(long runtimeLimitSec) {
                this.runtimeLimitSec = runtimeLimitSec;
                return this;
            }

            public Batch build() {
                return new Batch(this.retryPolicy, this.size, this.runtimeLimitSec);
            }

            public String toString() {
                return "TitusBatchJobRequest.Batch.BatchBuilder(retryPolicy=" + this.retryPolicy + ", size=" + this.size + ", runtimeLimitSec=" + this.runtimeLimitSec + ")";
            }
        }
    }

    public static class DisruptionBudget {
        @NotNull
        @NonNull
        private SelfManaged selfManaged;

        DisruptionBudget(@NotNull @NonNull SelfManaged selfManaged) {
            if (selfManaged == null) {
                throw new NullPointerException("selfManaged is marked non-null but is null");
            }
            this.selfManaged = selfManaged;
        }

        public static DisruptionBudgetBuilder builder() {
            return new DisruptionBudgetBuilder();
        }

        @NotNull
        @NonNull
        public SelfManaged getSelfManaged() {
            return this.selfManaged;
        }

        public void setSelfManaged(@NotNull @NonNull SelfManaged selfManaged) {
            if (selfManaged == null) {
                throw new NullPointerException("selfManaged is marked non-null but is null");
            }
            this.selfManaged = selfManaged;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisruptionBudget)) {
                return false;
            }
            DisruptionBudget other = (DisruptionBudget)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SelfManaged this$selfManaged = this.getSelfManaged();
            SelfManaged other$selfManaged = other.getSelfManaged();
            return !(this$selfManaged == null ? other$selfManaged != null : !((Object)this$selfManaged).equals(other$selfManaged));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DisruptionBudget;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SelfManaged $selfManaged = this.getSelfManaged();
            result = result * 59 + ($selfManaged == null ? 43 : ((Object)$selfManaged).hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.DisruptionBudget(selfManaged=" + this.getSelfManaged() + ")";
        }

        public static class DisruptionBudgetBuilder {
            private SelfManaged selfManaged;

            DisruptionBudgetBuilder() {
            }

            public DisruptionBudgetBuilder selfManaged(@NotNull @NonNull SelfManaged selfManaged) {
                if (selfManaged == null) {
                    throw new NullPointerException("selfManaged is marked non-null but is null");
                }
                this.selfManaged = selfManaged;
                return this;
            }

            public DisruptionBudget build() {
                return new DisruptionBudget(this.selfManaged);
            }

            public String toString() {
                return "TitusBatchJobRequest.DisruptionBudget.DisruptionBudgetBuilder(selfManaged=" + this.selfManaged + ")";
            }
        }
    }

    public static class JobGroupInfo {
        private String stack;
        private String detail;
        private String sequence;

        JobGroupInfo(String stack, String detail, String sequence) {
            this.stack = stack;
            this.detail = detail;
            this.sequence = sequence;
        }

        public static JobGroupInfoBuilder builder() {
            return new JobGroupInfoBuilder();
        }

        public String getStack() {
            return this.stack;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getSequence() {
            return this.sequence;
        }

        public void setStack(String stack) {
            this.stack = stack;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public void setSequence(String sequence) {
            this.sequence = sequence;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobGroupInfo)) {
                return false;
            }
            JobGroupInfo other = (JobGroupInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$stack = this.getStack();
            String other$stack = other.getStack();
            if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
                return false;
            }
            String this$detail = this.getDetail();
            String other$detail = other.getDetail();
            if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
                return false;
            }
            String this$sequence = this.getSequence();
            String other$sequence = other.getSequence();
            return !(this$sequence == null ? other$sequence != null : !this$sequence.equals(other$sequence));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobGroupInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $stack = this.getStack();
            result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
            String $detail = this.getDetail();
            result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
            String $sequence = this.getSequence();
            result = result * 59 + ($sequence == null ? 43 : $sequence.hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.JobGroupInfo(stack=" + this.getStack() + ", detail=" + this.getDetail() + ", sequence=" + this.getSequence() + ")";
        }

        public static class JobGroupInfoBuilder {
            private String stack;
            private String detail;
            private String sequence;

            JobGroupInfoBuilder() {
            }

            public JobGroupInfoBuilder stack(String stack) {
                this.stack = stack;
                return this;
            }

            public JobGroupInfoBuilder detail(String detail) {
                this.detail = detail;
                return this;
            }

            public JobGroupInfoBuilder sequence(String sequence) {
                this.sequence = sequence;
                return this;
            }

            public JobGroupInfo build() {
                return new JobGroupInfo(this.stack, this.detail, this.sequence);
            }

            public String toString() {
                return "TitusBatchJobRequest.JobGroupInfo.JobGroupInfoBuilder(stack=" + this.stack + ", detail=" + this.detail + ", sequence=" + this.sequence + ")";
            }
        }
    }

    public static class NetworkConfiguration {
        private String networkMode;

        NetworkConfiguration(String networkMode) {
            this.networkMode = networkMode;
        }

        public static NetworkConfigurationBuilder builder() {
            return new NetworkConfigurationBuilder();
        }

        public String getNetworkMode() {
            return this.networkMode;
        }

        public void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkConfiguration)) {
                return false;
            }
            NetworkConfiguration other = (NetworkConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$networkMode = this.getNetworkMode();
            String other$networkMode = other.getNetworkMode();
            return !(this$networkMode == null ? other$networkMode != null : !this$networkMode.equals(other$networkMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NetworkConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $networkMode = this.getNetworkMode();
            result = result * 59 + ($networkMode == null ? 43 : $networkMode.hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.NetworkConfiguration(networkMode=" + this.getNetworkMode() + ")";
        }

        public static class NetworkConfigurationBuilder {
            private String networkMode;

            NetworkConfigurationBuilder() {
            }

            public NetworkConfigurationBuilder networkMode(String networkMode) {
                this.networkMode = networkMode;
                return this;
            }

            public NetworkConfiguration build() {
                return new NetworkConfiguration(this.networkMode);
            }

            public String toString() {
                return "TitusBatchJobRequest.NetworkConfiguration.NetworkConfigurationBuilder(networkMode=" + this.networkMode + ")";
            }
        }
    }

    public static class TitusBatchJobRequestBuilder {
        private Owner owner;
        private Map<String, String> attributes;
        private Container container;
        private Batch batch;
        private DisruptionBudget disruptionBudget;
        private String applicationName;
        private String capacityGroup;
        private JobGroupInfo jobGroupInfo;
        private NetworkConfiguration networkConfiguration;

        TitusBatchJobRequestBuilder() {
        }

        public TitusBatchJobRequestBuilder owner(@NotNull @NonNull Owner owner) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            this.owner = owner;
            return this;
        }

        public TitusBatchJobRequestBuilder attributes(@NotNull @NonNull Map<String, String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            this.attributes = attributes;
            return this;
        }

        public TitusBatchJobRequestBuilder container(@NotNull @NonNull Container container) {
            if (container == null) {
                throw new NullPointerException("container is marked non-null but is null");
            }
            this.container = container;
            return this;
        }

        public TitusBatchJobRequestBuilder batch(@NotNull @NonNull Batch batch) {
            if (batch == null) {
                throw new NullPointerException("batch is marked non-null but is null");
            }
            this.batch = batch;
            return this;
        }

        public TitusBatchJobRequestBuilder disruptionBudget(@NotNull @NonNull DisruptionBudget disruptionBudget) {
            if (disruptionBudget == null) {
                throw new NullPointerException("disruptionBudget is marked non-null but is null");
            }
            this.disruptionBudget = disruptionBudget;
            return this;
        }

        public TitusBatchJobRequestBuilder applicationName(@NotNull @NonNull String applicationName) {
            if (applicationName == null) {
                throw new NullPointerException("applicationName is marked non-null but is null");
            }
            this.applicationName = applicationName;
            return this;
        }

        public TitusBatchJobRequestBuilder capacityGroup(@NotNull @NonNull String capacityGroup) {
            if (capacityGroup == null) {
                throw new NullPointerException("capacityGroup is marked non-null but is null");
            }
            this.capacityGroup = capacityGroup;
            return this;
        }

        public TitusBatchJobRequestBuilder jobGroupInfo(@NotNull @NonNull JobGroupInfo jobGroupInfo) {
            if (jobGroupInfo == null) {
                throw new NullPointerException("jobGroupInfo is marked non-null but is null");
            }
            this.jobGroupInfo = jobGroupInfo;
            return this;
        }

        public TitusBatchJobRequestBuilder networkConfiguration(@Nullable NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public TitusBatchJobRequest build() {
            return new TitusBatchJobRequest(this.owner, this.attributes, this.container, this.batch, this.disruptionBudget, this.applicationName, this.capacityGroup, this.jobGroupInfo, this.networkConfiguration);
        }

        public String toString() {
            return "TitusBatchJobRequest.TitusBatchJobRequestBuilder(owner=" + this.owner + ", attributes=" + this.attributes + ", container=" + this.container + ", batch=" + this.batch + ", disruptionBudget=" + this.disruptionBudget + ", applicationName=" + this.applicationName + ", capacityGroup=" + this.capacityGroup + ", jobGroupInfo=" + this.jobGroupInfo + ", networkConfiguration=" + this.networkConfiguration + ")";
        }
    }

    public static class SelfManaged {
        @Min(value=1L)
        private @Min(value=1L) long relocationTimeMs;

        SelfManaged(long relocationTimeMs) {
            this.relocationTimeMs = relocationTimeMs;
        }

        public static SelfManagedBuilder builder() {
            return new SelfManagedBuilder();
        }

        public long getRelocationTimeMs() {
            return this.relocationTimeMs;
        }

        public void setRelocationTimeMs(long relocationTimeMs) {
            this.relocationTimeMs = relocationTimeMs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelfManaged)) {
                return false;
            }
            SelfManaged other = (SelfManaged)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getRelocationTimeMs() == other.getRelocationTimeMs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelfManaged;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $relocationTimeMs = this.getRelocationTimeMs();
            result = result * 59 + (int)($relocationTimeMs >>> 32 ^ $relocationTimeMs);
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.SelfManaged(relocationTimeMs=" + this.getRelocationTimeMs() + ")";
        }

        public static class SelfManagedBuilder {
            private long relocationTimeMs;

            SelfManagedBuilder() {
            }

            public SelfManagedBuilder relocationTimeMs(long relocationTimeMs) {
                this.relocationTimeMs = relocationTimeMs;
                return this;
            }

            public SelfManaged build() {
                return new SelfManaged(this.relocationTimeMs);
            }

            public String toString() {
                return "TitusBatchJobRequest.SelfManaged.SelfManagedBuilder(relocationTimeMs=" + this.relocationTimeMs + ")";
            }
        }
    }

    public static class Immediate {
        @Min(value=0L)
        private @Min(value=0L) int retries;

        Immediate(int retries) {
            this.retries = retries;
        }

        public static ImmediateBuilder builder() {
            return new ImmediateBuilder();
        }

        public int getRetries() {
            return this.retries;
        }

        public void setRetries(int retries) {
            this.retries = retries;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Immediate)) {
                return false;
            }
            Immediate other = (Immediate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getRetries() == other.getRetries();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Immediate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRetries();
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.Immediate(retries=" + this.getRetries() + ")";
        }

        public static class ImmediateBuilder {
            private int retries;

            ImmediateBuilder() {
            }

            public ImmediateBuilder retries(int retries) {
                this.retries = retries;
                return this;
            }

            public Immediate build() {
                return new Immediate(this.retries);
            }

            public String toString() {
                return "TitusBatchJobRequest.Immediate.ImmediateBuilder(retries=" + this.retries + ")";
            }
        }
    }

    public static class RetryPolicy {
        @NotNull
        @NonNull
        private Immediate immediate;

        RetryPolicy(@NotNull @NonNull Immediate immediate) {
            if (immediate == null) {
                throw new NullPointerException("immediate is marked non-null but is null");
            }
            this.immediate = immediate;
        }

        public static RetryPolicyBuilder builder() {
            return new RetryPolicyBuilder();
        }

        @NotNull
        @NonNull
        public Immediate getImmediate() {
            return this.immediate;
        }

        public void setImmediate(@NotNull @NonNull Immediate immediate) {
            if (immediate == null) {
                throw new NullPointerException("immediate is marked non-null but is null");
            }
            this.immediate = immediate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryPolicy)) {
                return false;
            }
            RetryPolicy other = (RetryPolicy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Immediate this$immediate = this.getImmediate();
            Immediate other$immediate = other.getImmediate();
            return !(this$immediate == null ? other$immediate != null : !((Object)this$immediate).equals(other$immediate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryPolicy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Immediate $immediate = this.getImmediate();
            result = result * 59 + ($immediate == null ? 43 : ((Object)$immediate).hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.RetryPolicy(immediate=" + this.getImmediate() + ")";
        }

        public static class RetryPolicyBuilder {
            private Immediate immediate;

            RetryPolicyBuilder() {
            }

            public RetryPolicyBuilder immediate(@NotNull @NonNull Immediate immediate) {
                if (immediate == null) {
                    throw new NullPointerException("immediate is marked non-null but is null");
                }
                this.immediate = immediate;
                return this;
            }

            public RetryPolicy build() {
                return new RetryPolicy(this.immediate);
            }

            public String toString() {
                return "TitusBatchJobRequest.RetryPolicy.RetryPolicyBuilder(immediate=" + this.immediate + ")";
            }
        }
    }

    public static class Image {
        @NotEmpty
        @NonNull
        private String name;
        @NotEmpty
        @NonNull
        private String tag;

        Image(@NonNull String name, @NonNull String tag) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (tag == null) {
                throw new NullPointerException("tag is marked non-null but is null");
            }
            this.name = name;
            this.tag = tag;
        }

        public static ImageBuilder builder() {
            return new ImageBuilder();
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getTag() {
            return this.tag;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        public void setTag(@NonNull String tag) {
            if (tag == null) {
                throw new NullPointerException("tag is marked non-null but is null");
            }
            this.tag = tag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Image)) {
                return false;
            }
            Image other = (Image)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Image;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.Image(name=" + this.getName() + ", tag=" + this.getTag() + ")";
        }

        public static class ImageBuilder {
            private String name;
            private String tag;

            ImageBuilder() {
            }

            public ImageBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            public ImageBuilder tag(@NonNull String tag) {
                if (tag == null) {
                    throw new NullPointerException("tag is marked non-null but is null");
                }
                this.tag = tag;
                return this;
            }

            public Image build() {
                return new Image(this.name, this.tag);
            }

            public String toString() {
                return "TitusBatchJobRequest.Image.ImageBuilder(name=" + this.name + ", tag=" + this.tag + ")";
            }
        }
    }

    public static class ContainerConstraints {
        @NotNull
        @NonNull
        private Map<String, String> constraints;
        @NotNull
        @NonNull
        private String expression;

        private static String $default$expression() {
            return "";
        }

        ContainerConstraints(@NotNull @NonNull Map<String, String> constraints, @NotNull @NonNull String expression) {
            if (constraints == null) {
                throw new NullPointerException("constraints is marked non-null but is null");
            }
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.constraints = constraints;
            this.expression = expression;
        }

        public static ContainerConstraintsBuilder builder() {
            return new ContainerConstraintsBuilder();
        }

        @NotNull
        @NonNull
        public Map<String, String> getConstraints() {
            return this.constraints;
        }

        @NotNull
        @NonNull
        public String getExpression() {
            return this.expression;
        }

        public void setConstraints(@NotNull @NonNull Map<String, String> constraints) {
            if (constraints == null) {
                throw new NullPointerException("constraints is marked non-null but is null");
            }
            this.constraints = constraints;
        }

        public void setExpression(@NotNull @NonNull String expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContainerConstraints)) {
                return false;
            }
            ContainerConstraints other = (ContainerConstraints)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$constraints = this.getConstraints();
            Map<String, String> other$constraints = other.getConstraints();
            if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
                return false;
            }
            String this$expression = this.getExpression();
            String other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContainerConstraints;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $constraints = this.getConstraints();
            result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
            String $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.ContainerConstraints(constraints=" + this.getConstraints() + ", expression=" + this.getExpression() + ")";
        }

        public static class ContainerConstraintsBuilder {
            private Map<String, String> constraints;
            private boolean expression$set;
            private String expression$value;

            ContainerConstraintsBuilder() {
            }

            public ContainerConstraintsBuilder constraints(@NotNull @NonNull Map<String, String> constraints) {
                if (constraints == null) {
                    throw new NullPointerException("constraints is marked non-null but is null");
                }
                this.constraints = constraints;
                return this;
            }

            public ContainerConstraintsBuilder expression(@NotNull @NonNull String expression) {
                if (expression == null) {
                    throw new NullPointerException("expression is marked non-null but is null");
                }
                this.expression$value = expression;
                this.expression$set = true;
                return this;
            }

            public ContainerConstraints build() {
                String expression$value = this.expression$value;
                if (!this.expression$set) {
                    expression$value = ContainerConstraints.$default$expression();
                }
                return new ContainerConstraints(this.constraints, expression$value);
            }

            public String toString() {
                return "TitusBatchJobRequest.ContainerConstraints.ContainerConstraintsBuilder(constraints=" + this.constraints + ", expression$value=" + this.expression$value + ")";
            }
        }
    }

    public static class SecurityProfile {
        @NotNull
        @NonNull
        private Map<String, String> attributes;
        @NotNull
        @NonNull
        private List<String> securityGroups;
        @NotNull
        @NonNull
        private String iamRole;

        SecurityProfile(@NotNull @NonNull Map<String, String> attributes, @NotNull @NonNull List<String> securityGroups, @NotNull @NonNull String iamRole) {
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            if (securityGroups == null) {
                throw new NullPointerException("securityGroups is marked non-null but is null");
            }
            if (iamRole == null) {
                throw new NullPointerException("iamRole is marked non-null but is null");
            }
            this.attributes = attributes;
            this.securityGroups = securityGroups;
            this.iamRole = iamRole;
        }

        public static SecurityProfileBuilder builder() {
            return new SecurityProfileBuilder();
        }

        @NotNull
        @NonNull
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @NotNull
        @NonNull
        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @NotNull
        @NonNull
        public String getIamRole() {
            return this.iamRole;
        }

        public void setAttributes(@NotNull @NonNull Map<String, String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            this.attributes = attributes;
        }

        public void setSecurityGroups(@NotNull @NonNull List<String> securityGroups) {
            if (securityGroups == null) {
                throw new NullPointerException("securityGroups is marked non-null but is null");
            }
            this.securityGroups = securityGroups;
        }

        public void setIamRole(@NotNull @NonNull String iamRole) {
            if (iamRole == null) {
                throw new NullPointerException("iamRole is marked non-null but is null");
            }
            this.iamRole = iamRole;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SecurityProfile)) {
                return false;
            }
            SecurityProfile other = (SecurityProfile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$attributes = this.getAttributes();
            Map<String, String> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            List<String> this$securityGroups = this.getSecurityGroups();
            List<String> other$securityGroups = other.getSecurityGroups();
            if (this$securityGroups == null ? other$securityGroups != null : !((Object)this$securityGroups).equals(other$securityGroups)) {
                return false;
            }
            String this$iamRole = this.getIamRole();
            String other$iamRole = other.getIamRole();
            return !(this$iamRole == null ? other$iamRole != null : !this$iamRole.equals(other$iamRole));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SecurityProfile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            List<String> $securityGroups = this.getSecurityGroups();
            result = result * 59 + ($securityGroups == null ? 43 : ((Object)$securityGroups).hashCode());
            String $iamRole = this.getIamRole();
            result = result * 59 + ($iamRole == null ? 43 : $iamRole.hashCode());
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.SecurityProfile(attributes=" + this.getAttributes() + ", securityGroups=" + this.getSecurityGroups() + ", iamRole=" + this.getIamRole() + ")";
        }

        public static class SecurityProfileBuilder {
            private Map<String, String> attributes;
            private List<String> securityGroups;
            private String iamRole;

            SecurityProfileBuilder() {
            }

            public SecurityProfileBuilder attributes(@NotNull @NonNull Map<String, String> attributes) {
                if (attributes == null) {
                    throw new NullPointerException("attributes is marked non-null but is null");
                }
                this.attributes = attributes;
                return this;
            }

            public SecurityProfileBuilder securityGroups(@NotNull @NonNull List<String> securityGroups) {
                if (securityGroups == null) {
                    throw new NullPointerException("securityGroups is marked non-null but is null");
                }
                this.securityGroups = securityGroups;
                return this;
            }

            public SecurityProfileBuilder iamRole(@NotNull @NonNull String iamRole) {
                if (iamRole == null) {
                    throw new NullPointerException("iamRole is marked non-null but is null");
                }
                this.iamRole = iamRole;
                return this;
            }

            public SecurityProfile build() {
                return new SecurityProfile(this.attributes, this.securityGroups, this.iamRole);
            }

            public String toString() {
                return "TitusBatchJobRequest.SecurityProfile.SecurityProfileBuilder(attributes=" + this.attributes + ", securityGroups=" + this.securityGroups + ", iamRole=" + this.iamRole + ")";
            }
        }
    }

    public static class Resources {
        private int cpu;
        private int gpu;
        private long memoryMB;
        private long diskMB;
        private long networkMbps;

        Resources(int cpu, int gpu, long memoryMB, long diskMB, long networkMbps) {
            this.cpu = cpu;
            this.gpu = gpu;
            this.memoryMB = memoryMB;
            this.diskMB = diskMB;
            this.networkMbps = networkMbps;
        }

        public static ResourcesBuilder builder() {
            return new ResourcesBuilder();
        }

        public int getCpu() {
            return this.cpu;
        }

        public int getGpu() {
            return this.gpu;
        }

        public long getMemoryMB() {
            return this.memoryMB;
        }

        public long getDiskMB() {
            return this.diskMB;
        }

        public long getNetworkMbps() {
            return this.networkMbps;
        }

        public void setCpu(int cpu) {
            this.cpu = cpu;
        }

        public void setGpu(int gpu) {
            this.gpu = gpu;
        }

        public void setMemoryMB(long memoryMB) {
            this.memoryMB = memoryMB;
        }

        public void setDiskMB(long diskMB) {
            this.diskMB = diskMB;
        }

        public void setNetworkMbps(long networkMbps) {
            this.networkMbps = networkMbps;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resources)) {
                return false;
            }
            Resources other = (Resources)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCpu() != other.getCpu()) {
                return false;
            }
            if (this.getGpu() != other.getGpu()) {
                return false;
            }
            if (this.getMemoryMB() != other.getMemoryMB()) {
                return false;
            }
            if (this.getDiskMB() != other.getDiskMB()) {
                return false;
            }
            return this.getNetworkMbps() == other.getNetworkMbps();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resources;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCpu();
            result = result * 59 + this.getGpu();
            long $memoryMB = this.getMemoryMB();
            result = result * 59 + (int)($memoryMB >>> 32 ^ $memoryMB);
            long $diskMB = this.getDiskMB();
            result = result * 59 + (int)($diskMB >>> 32 ^ $diskMB);
            long $networkMbps = this.getNetworkMbps();
            result = result * 59 + (int)($networkMbps >>> 32 ^ $networkMbps);
            return result;
        }

        public String toString() {
            return "TitusBatchJobRequest.Resources(cpu=" + this.getCpu() + ", gpu=" + this.getGpu() + ", memoryMB=" + this.getMemoryMB() + ", diskMB=" + this.getDiskMB() + ", networkMbps=" + this.getNetworkMbps() + ")";
        }

        public static class ResourcesBuilder {
            private int cpu;
            private int gpu;
            private long memoryMB;
            private long diskMB;
            private long networkMbps;

            ResourcesBuilder() {
            }

            public ResourcesBuilder cpu(int cpu) {
                this.cpu = cpu;
                return this;
            }

            public ResourcesBuilder gpu(int gpu) {
                this.gpu = gpu;
                return this;
            }

            public ResourcesBuilder memoryMB(long memoryMB) {
                this.memoryMB = memoryMB;
                return this;
            }

            public ResourcesBuilder diskMB(long diskMB) {
                this.diskMB = diskMB;
                return this;
            }

            public ResourcesBuilder networkMbps(long networkMbps) {
                this.networkMbps = networkMbps;
                return this;
            }

            public Resources build() {
                return new Resources(this.cpu, this.gpu, this.memoryMB, this.diskMB, this.networkMbps);
            }

            public String toString() {
                return "TitusBatchJobRequest.Resources.ResourcesBuilder(cpu=" + this.cpu + ", gpu=" + this.gpu + ", memoryMB=" + this.memoryMB + ", diskMB=" + this.diskMB + ", networkMbps=" + this.networkMbps + ")";
            }
        }
    }
}

