/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.resources;

import com.netflix.genie.web.agent.services.AgentFileStreamService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import javax.annotation.Nullable;
import org.springframework.core.io.Resource;

public final class AgentFileResourceImpl
implements AgentFileStreamService.AgentFileResource {
    private final boolean exists;
    private final URI uri;
    private final long contentLength;
    private final long lastModified;
    private final String filename;
    private final String description;
    private final InputStream inputStream;

    private AgentFileResourceImpl(boolean exists, @Nullable URI uri, long contentLength, long lastModified, @Nullable String filename, String description, @Nullable InputStream inputStream) {
        this.exists = exists;
        this.uri = uri;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
        this.filename = filename;
        this.description = description;
        this.inputStream = inputStream;
    }

    public static AgentFileResourceImpl forNonExistingResource() {
        String description = AgentFileResourceImpl.class.getSimpleName() + " [ non-existent ]";
        return new AgentFileResourceImpl(false, null, -1L, -1L, null, description, null);
    }

    public static AgentFileStreamService.AgentFileResource forAgentFile(URI uri, long size, Instant lastModifiedTime, Path relativePath, String jobId, InputStream inputStream) {
        String description = AgentFileResourceImpl.class.getSimpleName() + " [ jobId:" + jobId + ",  relativePath: " + relativePath + " ]";
        Path filenamePath = relativePath.getFileName();
        if (filenamePath == null) {
            throw new IllegalArgumentException("Invalid relative path, not a file");
        }
        return new AgentFileResourceImpl(true, uri, size, lastModifiedTime.toEpochMilli(), filenamePath.toString(), description, inputStream);
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isOpen() {
        return true;
    }

    public URL getURL() throws IOException {
        throw new IOException("Cannot resolve to a URL");
    }

    public URI getURI() throws IOException {
        if (!this.exists()) {
            throw new IOException("Cannot determine URI of non-existent resource");
        }
        return this.uri;
    }

    public File getFile() throws IOException {
        throw new FileNotFoundException("Resource is not a local file");
    }

    public long contentLength() throws IOException {
        if (!this.exists()) {
            throw new IOException("Cannot determine size of non-existent resource");
        }
        return this.contentLength;
    }

    public long lastModified() throws IOException {
        if (!this.exists()) {
            throw new IOException("Cannot determine modification time of non-existent resource");
        }
        return this.lastModified;
    }

    public Resource createRelative(String relativePath) throws IOException {
        throw new IOException("Cannot create resource from relative path");
    }

    public String getFilename() {
        if (!this.exists()) {
            return null;
        }
        return this.filename;
    }

    public String getDescription() {
        return this.description;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("Resource does not exist");
        }
        return this.inputStream;
    }
}

