/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.observers;

import com.netflix.genie.common.internal.dtos.JobStatus;
import com.netflix.genie.web.data.observers.PersistedJobStatusObserver;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.events.JobStateChangeEvent;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedJobStatusObserverImpl
implements PersistedJobStatusObserver {
    private static final Logger log = LoggerFactory.getLogger(PersistedJobStatusObserverImpl.class);
    private final GenieEventBus genieEventBus;

    public PersistedJobStatusObserverImpl(GenieEventBus genieEventBus) {
        this.genieEventBus = genieEventBus;
    }

    @Override
    public void notify(String jobId, @Nullable JobStatus previousStatus, JobStatus currentStatus) {
        JobStateChangeEvent event = new JobStateChangeEvent(jobId, previousStatus, currentStatus, this);
        log.debug("Publishing event: {}", (Object)event);
        this.genieEventBus.publishAsynchronousEvent(event);
        log.info("Job {} status changed from: {} to: {}", new Object[]{jobId, previousStatus, currentStatus});
    }
}

