/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.entities;

import com.netflix.genie.web.data.services.impl.jpa.entities.IdEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="criteria")
public class CriterionEntity
extends IdEntity {
    @Basic
    @Column(name="unique_id", updatable=false)
    @Size(max=255, message="The id part of the criterion can't be longer than 255 characters")
    private @Size(max=255, message="The id part of the criterion can't be longer than 255 characters") String uniqueId;
    @Basic
    @Column(name="name", updatable=false)
    @Size(max=255, message="The name part of the criterion can't be longer than 255 characters")
    private @Size(max=255, message="The name part of the criterion can't be longer than 255 characters") String name;
    @Basic
    @Column(name="version", updatable=false)
    @Size(max=255, message="The version part of the criterion can't be longer than 255 characters")
    private @Size(max=255, message="The version part of the criterion can't be longer than 255 characters") String version;
    @Basic
    @Column(name="status", updatable=false)
    @Size(max=255, message="The status part of the criterion can't be longer than 255 characters")
    private @Size(max=255, message="The status part of the criterion can't be longer than 255 characters") String status;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="criteria_tags", joinColumns={@JoinColumn(name="criterion_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();

    public CriterionEntity(@Nullable String uniqueId, @Nullable String name, @Nullable String version, @Nullable String status, @Nullable Set<TagEntity> tags) {
        this.uniqueId = uniqueId;
        this.name = name;
        this.version = version;
        this.status = status;
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public Optional<String> getUniqueId() {
        return Optional.ofNullable(this.uniqueId);
    }

    public void setUniqueId(@Nullable String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public Optional<String> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public void setStatus(@Nullable String status) {
        this.status = status;
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public CriterionEntity() {
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    @Override
    public String toString() {
        return "CriterionEntity(super=" + super.toString() + ", uniqueId=" + this.uniqueId + ", name=" + this.name + ", version=" + this.version + ", status=" + this.status + ")";
    }
}

