/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.entities;

import com.netflix.genie.web.data.services.impl.jpa.entities.AuditEntity;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.Hibernate;

@MappedSuperclass
public class UniqueIdEntity
extends AuditEntity {
    @Basic(optional=false)
    @Column(name="unique_id", nullable=false, unique=true, updatable=false)
    @NotBlank(message="A unique identifier is missing and is required.")
    @Size(max=255, message="Max length in database is 255 characters")
    private @NotBlank(message="A unique identifier is missing and is required.") @Size(max=255, message="Max length in database is 255 characters") String uniqueId = UUID.randomUUID().toString();
    @Basic(optional=false)
    @Column(name="requested_id", nullable=false, updatable=false)
    private boolean requestedId;

    @Override
    @SuppressFBWarnings(value={"BC_EQUALS_METHOD_SHOULD_WORK_FOR_ALL_OBJECTS"})
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        UniqueIdEntity that = (UniqueIdEntity)o;
        return Objects.equals(this.uniqueId, that.uniqueId);
    }

    @Override
    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean isRequestedId() {
        return this.requestedId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setRequestedId(boolean requestedId) {
        this.requestedId = requestedId;
    }

    @Override
    public String toString() {
        return "UniqueIdEntity(super=" + super.toString() + ", uniqueId=" + this.uniqueId + ", requestedId=" + this.requestedId + ")";
    }
}

