/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.repositories;

import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaBaseRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaCommandRepository
extends JpaBaseRepository<CommandEntity> {
    public static final String FIND_UNUSED_COMMANDS_IN_STATUS_CREATED_BEFORE_QUERY = "SELECT id FROM commands WHERE status IN (:statuses) AND created < :commandCreatedThreshold AND id NOT IN (SELECT DISTINCT(command_id) FROM jobs WHERE command_id IS NOT NULL) LIMIT :limit";

    @Query(value="UPDATE CommandEntity c SET c.status = :desiredStatus WHERE c.id IN (:commandIds)")
    @Modifying
    public int setStatusWhereIdIn(@Param(value="desiredStatus") String var1, @Param(value="commandIds") Set<Long> var2);

    @Query(value="SELECT id FROM commands WHERE status IN (:statuses) AND created < :commandCreatedThreshold AND id NOT IN (SELECT DISTINCT(command_id) FROM jobs WHERE command_id IS NOT NULL) LIMIT :limit", nativeQuery=true)
    public Set<Long> findUnusedCommandsByStatusesCreatedBefore(@Param(value="statuses") Set<String> var1, @Param(value="commandCreatedThreshold") Instant var2, @Param(value="limit") int var3);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.applications", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandAndApplications(@Param(value="id") String var1);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.applications.dto", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandAndApplicationsDto(@Param(value="id") String var1);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.clusterCriteria", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandAndClusterCriteria(@Param(value="id") String var1);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.DTO", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandDto(@Param(value="id") String var1);
}

