/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.events;

import com.google.common.collect.Sets;
import com.netflix.genie.web.events.JobStateChangeEvent;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class JobNotificationMetricPublisher
implements ApplicationListener<JobStateChangeEvent> {
    private static final Logger log = LoggerFactory.getLogger(JobNotificationMetricPublisher.class);
    private static final String STATE_TRANSITION_METRIC_NAME = "genie.jobs.notifications.state-transition.counter";
    private static final String FINAL_STATE_METRIC_NAME = "genie.jobs.notifications.final-state.counter";
    private final MeterRegistry registry;

    public JobNotificationMetricPublisher(MeterRegistry registry) {
        this.registry = registry;
    }

    public void onApplicationEvent(JobStateChangeEvent event) {
        String fromStateString = event.getPreviousStatus() == null ? "null" : event.getPreviousStatus().name();
        String toStateString = event.getNewStatus().name();
        boolean isFinalState = event.getNewStatus().isFinished();
        log.debug("Job '{}' changed state from {} to {} {}", new Object[]{event.getJobId(), fromStateString, toStateString, isFinalState ? "(final state)" : ""});
        this.registry.counter(STATE_TRANSITION_METRIC_NAME, (Iterable)Sets.newHashSet((Object[])new Tag[]{Tag.of((String)"fromState", (String)fromStateString), Tag.of((String)"toState", (String)toStateString)})).increment();
        if (isFinalState) {
            this.registry.counter(FINAL_STATE_METRIC_NAME, new String[]{"toState", toStateString}).increment();
        }
    }
}

