/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.tasks.database-cleanup")
@Validated
public class DatabaseCleanupProperties {
    public static final String PROPERTY_PREFIX = "genie.tasks.database-cleanup";
    public static final String ENABLED_PROPERTY = "genie.tasks.database-cleanup.enabled";
    public static final String EXPRESSION_PROPERTY = "genie.tasks.database-cleanup.expression";
    public static final String BATCH_SIZE_PROPERTY = "genie.tasks.database-cleanup.batchSize";
    private boolean enabled;
    @NotBlank
    private String expression = "0 0 0 * * *";
    @Min(value=1L)
    private @Min(value=1L) int batchSize = 10000;
    @NotNull
    private ApplicationDatabaseCleanupProperties applicationCleanup = new ApplicationDatabaseCleanupProperties();
    @NotNull
    private ClusterDatabaseCleanupProperties clusterCleanup = new ClusterDatabaseCleanupProperties();
    @NotNull
    private CommandDatabaseCleanupProperties commandCleanup = new CommandDatabaseCleanupProperties();
    @NotNull
    private CommandDeactivationDatabaseCleanupProperties commandDeactivation = new CommandDeactivationDatabaseCleanupProperties();
    @NotNull
    private FileDatabaseCleanupProperties fileCleanup = new FileDatabaseCleanupProperties();
    @NotNull
    private JobDatabaseCleanupProperties jobCleanup = new JobDatabaseCleanupProperties();
    @NotNull
    private TagDatabaseCleanupProperties tagCleanup = new TagDatabaseCleanupProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @NotNull
    public ApplicationDatabaseCleanupProperties getApplicationCleanup() {
        return this.applicationCleanup;
    }

    @NotNull
    public ClusterDatabaseCleanupProperties getClusterCleanup() {
        return this.clusterCleanup;
    }

    @NotNull
    public CommandDatabaseCleanupProperties getCommandCleanup() {
        return this.commandCleanup;
    }

    @NotNull
    public CommandDeactivationDatabaseCleanupProperties getCommandDeactivation() {
        return this.commandDeactivation;
    }

    @NotNull
    public FileDatabaseCleanupProperties getFileCleanup() {
        return this.fileCleanup;
    }

    @NotNull
    public JobDatabaseCleanupProperties getJobCleanup() {
        return this.jobCleanup;
    }

    @NotNull
    public TagDatabaseCleanupProperties getTagCleanup() {
        return this.tagCleanup;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setApplicationCleanup(@NotNull ApplicationDatabaseCleanupProperties applicationCleanup) {
        this.applicationCleanup = applicationCleanup;
    }

    public void setClusterCleanup(@NotNull ClusterDatabaseCleanupProperties clusterCleanup) {
        this.clusterCleanup = clusterCleanup;
    }

    public void setCommandCleanup(@NotNull CommandDatabaseCleanupProperties commandCleanup) {
        this.commandCleanup = commandCleanup;
    }

    public void setCommandDeactivation(@NotNull CommandDeactivationDatabaseCleanupProperties commandDeactivation) {
        this.commandDeactivation = commandDeactivation;
    }

    public void setFileCleanup(@NotNull FileDatabaseCleanupProperties fileCleanup) {
        this.fileCleanup = fileCleanup;
    }

    public void setJobCleanup(@NotNull JobDatabaseCleanupProperties jobCleanup) {
        this.jobCleanup = jobCleanup;
    }

    public void setTagCleanup(@NotNull TagDatabaseCleanupProperties tagCleanup) {
        this.tagCleanup = tagCleanup;
    }

    public static class ApplicationDatabaseCleanupProperties {
        public static final String APPLICATION_CLEANUP_PROPERTY_PREFIX = "genie.tasks.database-cleanup.application-cleanup";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.application-cleanup.skip";
        private boolean skip;

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }
    }

    public static class ClusterDatabaseCleanupProperties {
        public static final String CLUSTER_CLEANUP_PROPERTY_PREFIX = "genie.tasks.database-cleanup.cluster-cleanup";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.cluster-cleanup.skip";
        private boolean skip;

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }
    }

    public static class CommandDatabaseCleanupProperties {
        public static final String COMMAND_CLEANUP_PROPERTY_PREFIX = "genie.tasks.database-cleanup.command-cleanup";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.command-cleanup.skip";
        private boolean skip;

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }
    }

    @Validated
    public static class CommandDeactivationDatabaseCleanupProperties {
        public static final String COMMAND_DEACTIVATION_PROPERTY_PREFIX = "genie.tasks.database-cleanup.command-deactivation";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.command-deactivation.skip";
        public static final String COMMAND_CREATION_THRESHOLD_PROPERTY = "genie.tasks.database-cleanup.command-deactivation.commandCreationThreshold";
        private boolean skip;
        @Min(value=1L)
        private @Min(value=1L) int commandCreationThreshold = 60;

        public boolean isSkip() {
            return this.skip;
        }

        public int getCommandCreationThreshold() {
            return this.commandCreationThreshold;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public void setCommandCreationThreshold(int commandCreationThreshold) {
            this.commandCreationThreshold = commandCreationThreshold;
        }
    }

    public static class FileDatabaseCleanupProperties {
        public static final String FILE_CLEANUP_PROPERTY_PREFIX = "genie.tasks.database-cleanup.file-cleanup";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.file-cleanup.skip";
        public static final String BATCH_DAYS_WITHIN_PROPERTY = "genie.tasks.database-cleanup.file-cleanup.batchDaysWithin";
        public static final String ROLLING_WINDOW_HOURS_PROPERTY = "genie.tasks.database-cleanup.file-cleanup.rollingWindowHours";
        private boolean skip;
        @Min(value=1L)
        private @Min(value=1L) int batchDaysWithin = 30;
        @Min(value=1L)
        private @Min(value=1L) int rollingWindowHours = 12;

        public boolean isSkip() {
            return this.skip;
        }

        public int getBatchDaysWithin() {
            return this.batchDaysWithin;
        }

        public int getRollingWindowHours() {
            return this.rollingWindowHours;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public void setBatchDaysWithin(int batchDaysWithin) {
            this.batchDaysWithin = batchDaysWithin;
        }

        public void setRollingWindowHours(int rollingWindowHours) {
            this.rollingWindowHours = rollingWindowHours;
        }
    }

    public static class JobDatabaseCleanupProperties {
        public static final String JOB_CLEANUP_PROPERTY_PREFIX = "genie.tasks.database-cleanup.job-cleanup";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.job-cleanup.skip";
        public static final String JOB_RETENTION_PROPERTY = "genie.tasks.database-cleanup.job-cleanup.retention";
        public static final String MAX_DELETED_PER_TRANSACTION_PROPERTY = "genie.tasks.database-cleanup.job-cleanup.maxDeletedPerTransaction";
        public static final String PAGE_SIZE_PROPERTY = "genie.tasks.database-cleanup.job-cleanup.pageSize";
        private boolean skip;
        private int retention = 90;
        private int maxDeletedPerTransaction = 1000;
        private int pageSize = 1000;

        public boolean isSkip() {
            return this.skip;
        }

        public int getRetention() {
            return this.retention;
        }

        public int getMaxDeletedPerTransaction() {
            return this.maxDeletedPerTransaction;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public void setRetention(int retention) {
            this.retention = retention;
        }

        public void setMaxDeletedPerTransaction(int maxDeletedPerTransaction) {
            this.maxDeletedPerTransaction = maxDeletedPerTransaction;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class TagDatabaseCleanupProperties {
        public static final String TAG_CLEANUP_PROPERTY_PREFIX = "genie.tasks.database-cleanup.tag-cleanup";
        public static final String SKIP_PROPERTY = "genie.tasks.database-cleanup.tag-cleanup.skip";
        public static final String BATCH_DAYS_WITHIN_PROPERTY = "genie.tasks.database-cleanup.tag-cleanup.batchDaysWithin";
        public static final String ROLLING_WINDOW_HOURS_PROPERTY = "genie.tasks.database-cleanup.tag-cleanup.rollingWindowHours";
        private boolean skip;
        @Min(value=1L)
        private @Min(value=1L) int batchDaysWithin = 30;
        @Min(value=1L)
        private @Min(value=1L) int rollingWindowHours = 12;

        public boolean isSkip() {
            return this.skip;
        }

        public int getBatchDaysWithin() {
            return this.batchDaysWithin;
        }

        public int getRollingWindowHours() {
            return this.rollingWindowHours;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public void setBatchDaysWithin(int batchDaysWithin) {
            this.batchDaysWithin = batchDaysWithin;
        }

        public void setRollingWindowHours(int rollingWindowHours) {
            this.rollingWindowHours = rollingWindowHours;
        }
    }
}

