/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Optional;
import javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public class ResourceSelectorScriptResult<R> {
    private final R resource;
    private final String rationale;

    private ResourceSelectorScriptResult(Builder<R> builder) {
        this.resource = builder.bResource;
        this.rationale = builder.bRationale;
    }

    public Optional<R> getResource() {
        return Optional.ofNullable(this.resource);
    }

    public Optional<String> getRationale() {
        return Optional.ofNullable(this.rationale);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceSelectorScriptResult)) {
            return false;
        }
        ResourceSelectorScriptResult other = (ResourceSelectorScriptResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        R this$resource = this.resource;
        R other$resource = other.resource;
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$rationale = this.rationale;
        String other$rationale = other.rationale;
        return !(this$rationale == null ? other$rationale != null : !this$rationale.equals(other$rationale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceSelectorScriptResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        R $resource = this.resource;
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        String $rationale = this.rationale;
        result = result * 59 + ($rationale == null ? 43 : $rationale.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceSelectorScriptResult(resource=" + this.resource + ", rationale=" + this.rationale + ")";
    }

    public static class Builder<R> {
        private R bResource;
        private String bRationale;

        public Builder<R> withResource(@Nullable R resource) {
            this.bResource = resource;
            return this;
        }

        public Builder<R> withRationale(@Nullable String rationale) {
            this.bRationale = rationale;
            return this;
        }

        public ResourceSelectorScriptResult<R> build() {
            return new ResourceSelectorScriptResult(this);
        }
    }
}

