/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.dtos.Command;
import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.scripts.CommandSelectorManagedScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.selectors.CommandSelectionContext;
import com.netflix.genie.web.selectors.CommandSelector;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptCommandSelectorImpl
implements CommandSelector {
    private static final Logger log = LoggerFactory.getLogger(ScriptCommandSelectorImpl.class);
    static final String SELECT_TIMER_NAME = "genie.selectors.command.script.select.timer";
    private static final String NULL_TAG = "null";
    private static final String NULL_RATIONALE = "Script returned no command, no preference";
    private final CommandSelectorManagedScript commandSelectorManagedScript;
    private final MeterRegistry registry;

    public ScriptCommandSelectorImpl(CommandSelectorManagedScript commandSelectorManagedScript, MeterRegistry registry) {
        this.commandSelectorManagedScript = commandSelectorManagedScript;
        this.registry = registry;
    }

    @Override
    public ResourceSelectionResult<Command> select(@Valid CommandSelectionContext context) throws ResourceSelectionException {
        long selectStart = System.nanoTime();
        String jobId = context.getJobId();
        Set<Command> resources = context.getResources();
        log.debug("Called to select a command from {} for job {}", resources, (Object)jobId);
        HashSet tags = Sets.newHashSet();
        ResourceSelectionResult.Builder builder = new ResourceSelectionResult.Builder(this.getClass());
        try {
            ResourceSelectorScriptResult<Command> result = this.commandSelectorManagedScript.selectResource(context);
            MetricsUtils.addSuccessTags(tags);
            Optional<Command> commandOptional = result.getResource();
            if (!commandOptional.isPresent()) {
                String rationale = result.getRationale().orElse(NULL_RATIONALE);
                log.debug("No command selected due to: {}", (Object)rationale);
                tags.add(Tag.of((String)"commandId", (String)NULL_TAG));
                builder.withSelectionRationale(rationale);
                ResourceSelectionResult<Command> resourceSelectionResult = builder.build();
                return resourceSelectionResult;
            }
            Command selectedCommand = commandOptional.get();
            tags.add(Tag.of((String)"commandId", (String)selectedCommand.getId()));
            tags.add(Tag.of((String)"commandName", (String)selectedCommand.getMetadata().getName()));
            ResourceSelectionResult<Command> resourceSelectionResult = builder.withSelectionRationale(result.getRationale().orElse(null)).withSelectedResource(selectedCommand).build();
            return resourceSelectionResult;
        }
        catch (Throwable e) {
            String errorMessage = "Command selection error: " + e.getMessage();
            log.error(errorMessage, e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            if (e instanceof ResourceSelectionException) {
                throw e;
            }
            throw new ResourceSelectionException(e);
        }
        finally {
            this.registry.timer(SELECT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - selectStart, TimeUnit.NANOSECONDS);
        }
    }
}

