/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.properties.JobsForwardingProperties;
import com.netflix.genie.web.services.RequestForwardingService;
import java.util.Enumeration;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.web.client.RestTemplate;

public class RequestForwardingServiceImpl
implements RequestForwardingService {
    private static final Logger log = LoggerFactory.getLogger(RequestForwardingServiceImpl.class);
    private static final String JOB_ENDPOINT = "/api/v3/jobs/";
    private static final String NAME_HEADER_COOKIE = "cookie";
    private final RestTemplate restTemplate;
    private final String hostname;
    private final String apiScheme;
    private final String apiPort;

    public RequestForwardingServiceImpl(RestTemplate restTemplate, GenieHostInfo hostInfo, JobsForwardingProperties jobsForwardingProperties) {
        this.restTemplate = restTemplate;
        this.hostname = hostInfo.getHostname();
        this.apiScheme = jobsForwardingProperties.getScheme() + "://";
        this.apiPort = ":" + jobsForwardingProperties.getPort();
    }

    @Override
    public void kill(String host, String jobId, @Nullable HttpServletRequest request) {
        String endpoint = this.buildDestinationHost(host) + JOB_ENDPOINT + jobId;
        log.info("Attempting to forward kill request by calling DELETE at {}", (Object)endpoint);
        try {
            this.restTemplate.execute(endpoint, HttpMethod.DELETE, forwardRequest -> {
                forwardRequest.getHeaders().add("Genie-Forwarded-From", this.hostname);
                if (request != null) {
                    this.copyRequestHeaders(request, forwardRequest);
                }
            }, null, new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed sending DELETE to {}. Error: {}", new Object[]{endpoint, e.getMessage(), e});
            throw e;
        }
    }

    private String buildDestinationHost(String destinationHost) {
        return this.apiScheme + destinationHost + this.apiPort;
    }

    private void copyRequestHeaders(HttpServletRequest request, ClientHttpRequest forwardRequest) {
        Cookie[] cookies;
        HttpHeaders headers = forwardRequest.getHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (NAME_HEADER_COOKIE.equals(headerName)) continue;
                String headerValue = request.getHeader(headerName);
                log.debug("Request Header: name = {} value = {}", (Object)headerName, (Object)headerValue);
                headers.add(headerName, headerValue);
            }
        }
        if ((cookies = request.getCookies()) != null && cookies.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (Cookie cookie : cookies) {
                if (builder.length() != 0) {
                    builder.append(",");
                }
                builder.append(cookie.getName()).append("=").append(cookie.getValue());
            }
            String cookieValue = builder.toString();
            headers.add(NAME_HEADER_COOKIE, cookieValue);
            log.debug("Request Header: name = {} value = {}", (Object)NAME_HEADER_COOKIE, (Object)cookieValue);
        }
        forwardRequest.getHeaders().add("Genie-Forwarded-From", this.hostname);
    }
}

