/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.launchers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.genie.common.internal.tracing.brave.BraveTracingComponents;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.impl.LocalAgentLauncherImpl;
import com.netflix.genie.web.agent.launchers.impl.TitusAgentLauncherImpl;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.introspection.GenieWebHostInfo;
import com.netflix.genie.web.introspection.GenieWebRpcInfo;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import com.netflix.genie.web.properties.TitusAgentLauncherProperties;
import com.netflix.genie.web.util.ExecutorFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={LocalAgentLauncherProperties.class, TitusAgentLauncherProperties.class})
@AutoConfigureAfter(value={RestTemplateAutoConfiguration.class})
public class AgentLaunchersAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(name={"titusRestTemplate"})
    public RestTemplate titusRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={TitusAgentLauncherImpl.TitusJobRequestAdapter.class})
    public TitusAgentLauncherImpl.TitusJobRequestAdapter titusJobRequestAdapter() {
        return new TitusAgentLauncherImpl.TitusJobRequestAdapter(){};
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(name={"titusAPIRetryPolicy"}, value={RetryPolicy.class})
    public TitusAgentLauncherImpl.TitusAPIRetryPolicy titusAPIRetryPolicy() {
        return new TitusAgentLauncherImpl.TitusAPIRetryPolicy(EnumSet.of(HttpStatus.SERVICE_UNAVAILABLE, HttpStatus.REQUEST_TIMEOUT), 3);
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(name={"titusAPIBackoffPolicy"}, value={BackOffPolicy.class})
    public ExponentialBackOffPolicy titusAPIBackoffPolicy() {
        return new ExponentialBackOffPolicy();
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(name={"titusAPIRetryTemplate"}, value={RetryTemplate.class})
    public RetryTemplate titusAPIRetryTemplate(@Qualifier(value="titusAPIRetryPolicy") RetryPolicy retryPolicy, @Qualifier(value="titusAPIBackoffPolicy") BackOffPolicy backOffPolicy) {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy(retryPolicy);
        retryTemplate.setBackOffPolicy(backOffPolicy);
        return retryTemplate;
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    public TitusAgentLauncherImpl titusAgentLauncher(@Qualifier(value="titusRestTemplate") RestTemplate restTemplate, @Qualifier(value="titusAPIRetryTemplate") RetryTemplate retryTemplate, TitusAgentLauncherImpl.TitusJobRequestAdapter titusJobRequestAdapter, GenieHostInfo genieHostInfo, TitusAgentLauncherProperties titusAgentLauncherProperties, BraveTracingComponents tracingComponents, Environment environment, MeterRegistry registry) {
        Cache healthIndicatorCache = Caffeine.newBuilder().maximumSize((long)titusAgentLauncherProperties.getHealthIndicatorMaxSize()).expireAfterWrite(titusAgentLauncherProperties.getHealthIndicatorExpiration().getSeconds(), TimeUnit.SECONDS).build();
        return new TitusAgentLauncherImpl(restTemplate, retryTemplate, titusJobRequestAdapter, (Cache<String, String>)healthIndicatorCache, genieHostInfo, titusAgentLauncherProperties, tracingComponents, environment, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExecutorFactory.class})
    public ExecutorFactory processExecutorFactory() {
        return new ExecutorFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.local.enabled"}, havingValue="true")
    public LocalAgentLauncherImpl localAgentLauncher(GenieWebHostInfo genieWebHostInfo, GenieWebRpcInfo genieWebRpcInfo, DataServices dataServices, LocalAgentLauncherProperties launcherProperties, ExecutorFactory executorFactory, BraveTracingComponents tracingComponents, MeterRegistry registry) {
        return new LocalAgentLauncherImpl(genieWebHostInfo, genieWebRpcInfo, dataServices, launcherProperties, executorFactory, tracingComponents, registry);
    }
}

