/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.jersey;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.spi.BindingScopingVisitor;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCProxiedComponentProvider;
import com.sun.jersey.guice.spi.container.GuiceComponentProviderFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GovernatorComponentProviderFactory
implements IoCComponentProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceComponentProviderFactory.class);
    private final Map<Scope, ComponentScope> scopeMap = this.createScopeMap();
    private final Injector injector;

    public GovernatorComponentProviderFactory(ResourceConfig config, Injector injector) {
        if (injector == null) {
            throw new NullPointerException("Guice Injector can not be null!");
        }
        this.injector = injector;
    }

    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, Class<?> clazz) {
        Injector i;
        Key key;
        block6: {
            LOGGER.info("getComponentProvider({0})", (Object)clazz.getName());
            key = Key.get(clazz);
            i = this.findInjector(key);
            if (i == null) {
                if (this.isGuiceConstructorInjected(clazz)) {
                    try {
                        if (this.injector.getBinding(key) != null) {
                            LOGGER.info("Binding {0} to GuiceInstantiatedComponentProvider", (Object)clazz.getName());
                            return new GuiceInstantiatedComponentProvider(this.injector, clazz);
                        }
                        break block6;
                    }
                    catch (ConfigurationException e) {
                        LOGGER.error("Cannot bind " + clazz.getName(), (Throwable)e);
                        throw e;
                    }
                }
                if (this.isGuiceFieldOrMethodInjected(clazz)) {
                    LOGGER.info("Binding {0} to GuiceInjectedComponentProvider", (Object)clazz.getName());
                    return new GuiceInjectedComponentProvider(this.injector);
                }
                return null;
            }
        }
        ComponentScope componentScope = this.getComponentScope(key, i);
        LOGGER.info("Binding {0} to GuiceManagedComponentProvider with the scope \"{1}\"", new Object[]{clazz.getName(), componentScope});
        return new GuiceManagedComponentProvider(i, componentScope, clazz);
    }

    private ComponentScope getComponentScope(Key<?> key, Injector i) {
        return (ComponentScope)i.getBinding(key).acceptScopingVisitor((BindingScopingVisitor)new BindingScopingVisitor<ComponentScope>(){

            public ComponentScope visitEagerSingleton() {
                return ComponentScope.Singleton;
            }

            public ComponentScope visitScope(Scope theScope) {
                ComponentScope cs = (ComponentScope)GovernatorComponentProviderFactory.this.scopeMap.get(theScope);
                return cs != null ? cs : ComponentScope.Undefined;
            }

            public ComponentScope visitScopeAnnotation(Class scopeAnnotation) {
                throw new UnsupportedOperationException();
            }

            public ComponentScope visitNoScoping() {
                return ComponentScope.PerRequest;
            }
        });
    }

    private Injector findInjector(Key<?> key) {
        for (Injector i = this.injector; i != null; i = i.getParent()) {
            if (!i.getBindings().containsKey(key)) continue;
            return i;
        }
        return null;
    }

    @Deprecated
    public boolean isImplicitGuiceComponent(Class<?> c) {
        return this.isGuiceConstructorInjected(c);
    }

    public boolean isGuiceConstructorInjected(Class<?> c) {
        for (Constructor<?> con : c.getDeclaredConstructors()) {
            if (!GovernatorComponentProviderFactory.isInjectable(con)) continue;
            return true;
        }
        return false;
    }

    public boolean isGuiceFieldOrMethodInjected(Class<?> c) {
        for (Method method : c.getDeclaredMethods()) {
            if (!GovernatorComponentProviderFactory.isInjectable(method)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
            if (!GovernatorComponentProviderFactory.isInjectable(accessibleObject)) continue;
            return true;
        }
        return !c.equals(Object.class) && this.isGuiceFieldOrMethodInjected(c.getSuperclass());
    }

    private static boolean isInjectable(AnnotatedElement element) {
        return element.isAnnotationPresent(Inject.class) || element.isAnnotationPresent(javax.inject.Inject.class);
    }

    public Map<Scope, ComponentScope> createScopeMap() {
        HashMap<Scope, ComponentScope> result = new HashMap<Scope, ComponentScope>();
        result.put(Scopes.SINGLETON, ComponentScope.Singleton);
        result.put(Scopes.NO_SCOPE, ComponentScope.PerRequest);
        result.put(ServletScopes.REQUEST, ComponentScope.PerRequest);
        return result;
    }

    private static class GuiceManagedComponentProvider
    extends GuiceInstantiatedComponentProvider
    implements IoCManagedComponentProvider {
        private final ComponentScope scope;

        public GuiceManagedComponentProvider(Injector injector, ComponentScope scope, Class<?> clazz) {
            super(injector, clazz);
            this.scope = scope;
        }

        public ComponentScope getScope() {
            return this.scope;
        }
    }

    private static class GuiceInstantiatedComponentProvider
    implements IoCInstantiatedComponentProvider {
        private final Injector injector;
        private final Class<?> clazz;

        public GuiceInstantiatedComponentProvider(Injector injector, Class<?> clazz) {
            this.injector = injector;
            this.clazz = clazz;
        }

        public Class<?> getInjectableClass(Class<?> c) {
            return c.getSuperclass();
        }

        public Object getInjectableInstance(Object o) {
            return o;
        }

        public Object getInstance() {
            try {
                return this.injector.getInstance(this.clazz);
            }
            catch (ProvisionException e) {
                if (e.getCause() instanceof WebApplicationException) {
                    throw (WebApplicationException)e.getCause();
                }
                throw e;
            }
        }
    }

    private static class GuiceInjectedComponentProvider
    implements IoCProxiedComponentProvider {
        private final Injector injector;

        public GuiceInjectedComponentProvider(Injector injector) {
            this.injector = injector;
        }

        public Object getInstance() {
            throw new IllegalStateException();
        }

        public Object proxy(Object o) {
            try {
                this.injector.injectMembers(o);
            }
            catch (ProvisionException e) {
                if (e.getCause() instanceof WebApplicationException) {
                    throw (WebApplicationException)e.getCause();
                }
                throw e;
            }
            return o;
        }
    }
}

