/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.servlet;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import com.netflix.governator.guice.servlet.GovernatorServletContextListener;
import com.netflix.governator.guice.servlet.WebApplicationInitializer;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={WebApplicationInitializer.class})
public class GovernatorServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> initializerClasses, ServletContext servletContext) throws ServletException {
        final WebApplicationInitializer initializer = this.getInitializer(initializerClasses, servletContext);
        if (initializer != null) {
            servletContext.addFilter("guiceFilter", (Filter)new GuiceFilter()).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
            servletContext.addListener((EventListener)((Object)new GovernatorServletContextListener(){

                @Override
                protected Injector createInjector() throws Exception {
                    return initializer.createInjector();
                }
            }));
        }
    }

    private WebApplicationInitializer getInitializer(Set<Class<?>> initializerClasses, ServletContext servletContext) throws ServletException {
        LinkedList<WebApplicationInitializer> initializers = new LinkedList<WebApplicationInitializer>();
        if (initializerClasses != null) {
            for (Class<?> initializerClass : initializerClasses) {
                if (initializerClass.isInterface() || Modifier.isAbstract(initializerClass.getModifiers()) || !WebApplicationInitializer.class.isAssignableFrom(initializerClass)) continue;
                try {
                    initializers.add((WebApplicationInitializer)initializerClass.newInstance());
                }
                catch (Throwable ex) {
                    throw new ServletException("Failed to instantiate WebApplicationInitializer class", ex);
                }
            }
        }
        if (initializers.isEmpty()) {
            servletContext.log("No WebApplicationInitializer types found on classpath");
            return null;
        }
        if (initializers.size() > 1) {
            servletContext.log("Multiple WebApplicationInitializer types found on classpath. Expected one but found " + initializers.size());
            return null;
        }
        return (WebApplicationInitializer)initializers.get(0);
    }
}

