/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class LifecycleTester
extends ExternalResource {
    private BootstrapModule[] suites;
    private Injector injector;
    private Class<?> bootstrap;
    private LifecycleInjectorBuilder builder;
    private Module externalModule;

    public LifecycleTester(List<BootstrapModule> suites) {
        this.suites = suites.toArray(new BootstrapModule[suites.size()]);
    }

    public LifecycleTester(BootstrapModule ... suites) {
        this.suites = suites;
    }

    public LifecycleTester(Class bootstrap, BootstrapModule ... suites) {
        this.bootstrap = bootstrap;
        this.suites = suites;
    }

    public Injector start() {
        if (this.bootstrap != null) {
            this.injector = LifecycleInjector.bootstrap(this.bootstrap, (Module)this.externalModule, (BootstrapModule[])this.suites);
        } else {
            this.builder = LifecycleInjector.builder();
            this.injector = this.builder.build().createInjector();
        }
        LifecycleManager manager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        try {
            manager.start();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return this.injector;
    }

    public LifecycleTester withBootstrapModule(BootstrapModule bootstrapModule) {
        if (this.suites == null || this.suites.length == 0) {
            this.suites = new BootstrapModule[]{bootstrapModule};
        } else {
            this.suites = Arrays.copyOf(this.suites, this.suites.length + 1);
            this.suites[this.suites.length - 1] = bootstrapModule;
        }
        return this;
    }

    public LifecycleTester withExternalBindings(Module module) {
        this.externalModule = module;
        return this;
    }

    public LifecycleInjectorBuilder builder() {
        return this.builder;
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public <T> T getInstance(Key<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public <T> T getInstance(TypeLiteral<T> type) {
        return (T)this.injector.getInstance(Key.get(type));
    }

    protected void after() {
        if (this.injector != null) {
            LifecycleManager manager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
            try {
                manager.close();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

