/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.test;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.guice.Raw;
import com.netflix.archaius.test.TestCompositeConfig;
import com.netflix.archaius.test.TestPropertyOverride;
import com.netflix.archaius.test.TestPropertyOverrideAnnotationReader;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.guice.test.CopyBindingTargetVisitor;
import com.netflix.governator.guice.test.ModulesForTesting;
import com.netflix.governator.guice.test.ReplaceWithMock;
import com.netflix.governator.guice.test.WrapWithSpy;
import com.netflix.governator.providers.SingletonProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.ClassUtils;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class AnnotationBasedTestInjectorManager {
    private final LifecycleInjector injector;
    private final List<Object> mocksToReset = new ArrayList<Object>();
    private final List<Module> modulesForTestClass = new ArrayList<Module>();
    private final List<Module> overrideModules = new ArrayList<Module>();
    private final List<Key<?>> spyTargets = new ArrayList();
    private final SettableConfig classLevelOverrides = new DefaultSettableConfig();
    private final SettableConfig methodLevelOverrides = new DefaultSettableConfig();
    private final TestPropertyOverrideAnnotationReader testPropertyOverrideAnnotationReader = new TestPropertyOverrideAnnotationReader();
    private TestCompositeConfig testCompositeConfig;

    public AnnotationBasedTestInjectorManager(Class<?> classUnderTest) {
        this.inspectModulesForTestClass(classUnderTest);
        this.inspectMocksForTestClass(classUnderTest);
        this.inspectSpiesForTargetKeys(Elements.getElements(this.modulesForTestClass));
        this.testCompositeConfig = new TestCompositeConfig(this.classLevelOverrides, this.methodLevelOverrides);
        this.overrideModules.add((Module)new ArchaiusTestConfigOverrideModule(this.testCompositeConfig));
        this.injector = this.createInjector(this.modulesForTestClass, this.overrideModules);
    }

    public void prepareTestFixture(Object testFixture) {
        this.injector.injectMembers(testFixture);
    }

    public void cleanupMocks() {
        for (Object mock : this.mocksToReset) {
            Mockito.reset((Object[])new Object[]{mock});
        }
    }

    public void cleanupInjector() {
        this.injector.close();
    }

    protected LifecycleInjector createInjector(List<Module> modules, List<Module> overrides) {
        return InjectorBuilder.fromModules(modules).overrideWith(overrides).createInjector();
    }

    private void inspectModulesForTestClass(Class<?> testClass) {
        ArrayList<Class<? extends Module>> moduleClasses = new ArrayList<Class<? extends Module>>();
        moduleClasses.addAll(this.getModulesForAnnotatedClass(testClass));
        for (Class<?> clazz : this.getAllSuperClassesInReverseOrder(testClass)) {
            moduleClasses.addAll(this.getModulesForAnnotatedClass(clazz));
        }
        for (Class<Object> clazz : moduleClasses) {
            try {
                this.modulesForTestClass.add((Module)clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                try {
                    Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
                    constructor.setAccessible(true);
                    this.modulesForTestClass.add((Module)constructor.newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiating module " + clazz + ". Please ensure that the module is public and has a no-arg constructor", e);
                }
            }
        }
    }

    private List<Class<? extends Module>> getModulesForAnnotatedClass(Class<?> testClass) {
        ModulesForTesting annotation = testClass.getAnnotation(ModulesForTesting.class);
        if (annotation != null) {
            return Arrays.asList(annotation.value());
        }
        return Collections.emptyList();
    }

    private void inspectMocksForTestClass(Class<?> testClass) {
        this.getMocksForAnnotatedFields(testClass);
        for (Class<?> parentClass : this.getAllSuperClassesInReverseOrder(testClass)) {
            this.getMocksForAnnotatedFields(parentClass);
        }
    }

    private void getMocksForAnnotatedFields(Class<?> testClass) {
        for (Field field : testClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(ReplaceWithMock.class)) {
                this.overrideModules.add((Module)new MockitoOverrideModule(field.getAnnotation(ReplaceWithMock.class), field.getType()));
            }
            if (!field.isAnnotationPresent(WrapWithSpy.class)) continue;
            WrapWithSpy spyAnnotation = field.getAnnotation(WrapWithSpy.class);
            if (spyAnnotation.name().isEmpty()) {
                this.spyTargets.add(Key.get(field.getType()));
                continue;
            }
            this.spyTargets.add(Key.get(field.getType(), (Annotation)Names.named((String)spyAnnotation.name())));
        }
    }

    private void inspectSpiesForTargetKeys(List<Element> elements) {
        for (Element element : elements) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    final Binding<T> finalBinding = binding;
                    if (AnnotationBasedTestInjectorManager.this.spyTargets.contains(binding.getKey())) {
                        AbstractModule spyModule = new AbstractModule(){

                            protected void configure() {
                                String finalBindingName = "Spied " + (finalBinding.getKey().getAnnotation() != null ? finalBinding.getKey().getAnnotation().toString() : "") + finalBinding.getKey().getTypeLiteral();
                                final Key newUniqueKey = Key.get((TypeLiteral)finalBinding.getKey().getTypeLiteral(), (Annotation)Names.named((String)finalBindingName));
                                finalBinding.acceptTargetVisitor(new CopyBindingTargetVisitor(this.binder().bind(newUniqueKey)));
                                this.bind(finalBinding.getKey()).toProvider((Provider)new SingletonProvider<T>(){
                                    @Inject
                                    Injector injector;

                                    protected T create() {
                                        Object t = this.injector.getInstance(newUniqueKey);
                                        return Mockito.spy((Object)t);
                                    }
                                });
                            }
                        };
                        AnnotationBasedTestInjectorManager.this.overrideModules.add(spyModule);
                    }
                    return null;
                }
            });
        }
    }

    public void prepareConfigForTestClass(Class<?> testClass, Method testMethod) {
        for (Class<?> parentClass : this.getAllSuperClassesInReverseOrder(testClass)) {
            this.classLevelOverrides.setProperties(this.testPropertyOverrideAnnotationReader.getPropertiesForAnnotation(parentClass.getAnnotation(TestPropertyOverride.class)));
        }
        this.classLevelOverrides.setProperties(this.testPropertyOverrideAnnotationReader.getPropertiesForAnnotation(testClass.getAnnotation(TestPropertyOverride.class)));
        this.methodLevelOverrides.setProperties(this.testPropertyOverrideAnnotationReader.getPropertiesForAnnotation(testMethod.getAnnotation(TestPropertyOverride.class)));
    }

    public void cleanUpMethodLevelConfig() {
        this.testCompositeConfig.resetForTest();
    }

    private List<Class<?>> getAllSuperClassesInReverseOrder(Class<?> clazz) {
        List allSuperclasses = ClassUtils.getAllSuperclasses(clazz);
        Collections.reverse(allSuperclasses);
        return allSuperclasses;
    }

    private class ArchaiusTestConfigOverrideModule
    extends AbstractModule {
        private TestCompositeConfig config;

        public ArchaiusTestConfigOverrideModule(TestCompositeConfig config) {
            this.config = config;
        }

        protected void configure() {
            this.bind(CompositeConfig.class).annotatedWith(Raw.class).toInstance((Object)this.config);
        }
    }

    private class MockitoOverrideModule<T>
    extends AbstractModule {
        private final ReplaceWithMock annotation;
        private final Class<T> classToBind;

        public MockitoOverrideModule(ReplaceWithMock annotation, Class<T> classToBind) {
            this.annotation = annotation;
            this.classToBind = classToBind;
        }

        protected void configure() {
            Object mock = Mockito.mock(this.classToBind, (Answer)this.annotation.answer().get());
            AnnotationBasedTestInjectorManager.this.mocksToReset.add(mock);
            AnnotatedBindingBuilder bindingBuilder = this.bind(this.classToBind);
            if (!this.annotation.name().isEmpty()) {
                bindingBuilder = bindingBuilder.annotatedWith((Annotation)Names.named((String)this.annotation.name()));
            }
            bindingBuilder.toInstance(mock);
        }
    }
}

