/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.test.junit4;

import com.netflix.governator.guice.test.AnnotationBasedTestInjectorManager;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class GovernatorJunit4ClassRunner
extends BlockJUnit4ClassRunner {
    private final AnnotationBasedTestInjectorManager annotationBasedTestInjectorManager;

    public GovernatorJunit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.annotationBasedTestInjectorManager = new AnnotationBasedTestInjectorManager(klass);
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.annotationBasedTestInjectorManager.prepareTestFixture(testInstance);
        return testInstance;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        this.annotationBasedTestInjectorManager.prepareConfigForTestClass(this.getDescription().getTestClass(), method.getMethod());
        return super.methodBlock(method);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return new RunAfters(statement, afters, target){

            public void evaluate() throws Throwable {
                super.evaluate();
                GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanUpMethodLevelConfig();
                GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanupMocks();
            }
        };
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return new RunAfters(statement, afters, null){

            public void evaluate() throws Throwable {
                super.evaluate();
                GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanupInjector();
            }
        };
    }
}

