/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.test.junit4;

import com.netflix.governator.guice.test.AnnotationBasedTestInjectorManager;
import com.netflix.governator.guice.test.InjectorCreationMode;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class GovernatorJunit4ClassRunner
extends BlockJUnit4ClassRunner {
    private AnnotationBasedTestInjectorManager annotationBasedTestInjectorManager;

    public GovernatorJunit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement classBlock(RunNotifier notifier) {
        this.annotationBasedTestInjectorManager = new AnnotationBasedTestInjectorManager(this.getTestClass().getJavaClass());
        this.annotationBasedTestInjectorManager.prepareConfigForTestClass(this.getDescription().getTestClass());
        if (InjectorCreationMode.BEFORE_TEST_CLASS == this.annotationBasedTestInjectorManager.getInjectorCreationMode()) {
            this.annotationBasedTestInjectorManager.createInjector();
        }
        return super.classBlock(notifier);
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.annotationBasedTestInjectorManager.prepareTestFixture(testInstance);
        return testInstance;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        this.annotationBasedTestInjectorManager.prepareConfigForTestClass(this.getDescription().getTestClass(), method.getMethod());
        if (InjectorCreationMode.BEFORE_EACH_TEST_METHOD == this.annotationBasedTestInjectorManager.getInjectorCreationMode()) {
            this.annotationBasedTestInjectorManager.createInjector();
        }
        return super.methodBlock(method);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return new RunAfters(statement, afters, target){

            public void evaluate() throws Throwable {
                try {
                    super.evaluate();
                }
                finally {
                    GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanUpMethodLevelConfig();
                    GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanUpMocks();
                    if (InjectorCreationMode.BEFORE_EACH_TEST_METHOD == GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.getInjectorCreationMode()) {
                        GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanUpInjector();
                    }
                }
            }
        };
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return new RunAfters(statement, afters, null){

            public void evaluate() throws Throwable {
                try {
                    super.evaluate();
                }
                finally {
                    GovernatorJunit4ClassRunner.this.annotationBasedTestInjectorManager.cleanUpInjector();
                }
            }
        };
    }
}

