/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.client.GraphQLError;
import com.netflix.graphql.dgs.client.RequestDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015B3\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0013\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\fJ\u001f\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010!\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010!\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\u0010$J'\u0010#\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010!\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u001c0&\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u0004\u0018\u00010)J\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\bH\u00c2\u0003J9\u0010/\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u00100\u001a\u00020+2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00066"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "", "json", "", "headers", "", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/String;Ljava/util/Map;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/util/Map;)V", "getJson", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "parsed", "Lcom/jayway/jsonpath/DocumentContext;", "getParsed", "()Lcom/jayway/jsonpath/DocumentContext;", "data", "getData", "errors", "Lcom/netflix/graphql/dgs/client/GraphQLError;", "getErrors", "()Ljava/util/List;", "dataAsObject", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "extractValue", "path", "(Ljava/lang/String;)Ljava/lang/Object;", "extractValueAsObject", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Lcom/jayway/jsonpath/TypeRef;)Ljava/lang/Object;", "getRequestDetails", "Lcom/netflix/graphql/dgs/client/RequestDetails;", "hasErrors", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nGraphQLResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLResponse.kt\ncom/netflix/graphql/dgs/client/GraphQLResponse\n+ 2 GraphQLResponse.kt\ncom/netflix/graphql/dgs/client/GraphQLResponseKt\n*L\n1#1,175:1\n174#2:176\n*S KotlinDebug\n*F\n+ 1 GraphQLResponse.kt\ncom/netflix/graphql/dgs/client/GraphQLResponse\n*L\n67#1:176\n*E\n"})
public final class GraphQLResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String json;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final DocumentContext parsed;
    @NotNull
    private final Map<String, Object> data;
    @NotNull
    private final List<GraphQLError> errors;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper DEFAULT_MAPPER;

    public GraphQLResponse(@Language(value="json") @NotNull String json, @NotNull Map<String, ? extends List<String>> headers, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.json = json;
        this.headers = headers;
        this.mapper = mapper;
        Option[] optionArray = new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL};
        DocumentContext documentContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(this.mapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(this.mapper)).build().addOptions(optionArray)).parse(this.json);
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parse(...)");
        this.parsed = documentContext;
        Map map = (Map)this.parsed.read("data", new Predicate[0]);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        this.data = map;
        boolean $i$f$jsonTypeRef = false;
        List list = (List)this.parsed.read("errors", (TypeRef)new TypeRef<List<? extends GraphQLError>>(){});
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.errors = list;
    }

    @NotNull
    public final String getJson() {
        return this.json;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final DocumentContext getParsed() {
        return this.parsed;
    }

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    @NotNull
    public final List<GraphQLError> getErrors() {
        return this.errors;
    }

    public GraphQLResponse(@Language(value="json") @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this(json, MapsKt.emptyMap());
    }

    public GraphQLResponse(@Language(value="json") @NotNull String json, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this(json, headers, DEFAULT_MAPPER);
    }

    public final <T> T dataAsObject(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.mapper.convertValue(this.data, clazz);
    }

    public final <T> T extractValue(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String dataPath = Companion.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, new Predicate[0]);
        }
        catch (Exception ex) {
            logger.warn("Error extracting path '" + path + "' from data: '" + this.data + "'");
            throw ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String dataPath = Companion.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, clazz, new Predicate[0]);
        }
        catch (Exception ex) {
            logger.warn("Error extracting path '" + path + "' from data: '" + this.data + "'");
            throw ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull TypeRef<T> typeRef) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String dataPath = Companion.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, typeRef);
        }
        catch (Exception ex) {
            logger.warn("Error extracting path '" + path + "' from data: '" + this.data + "'");
            throw ex;
        }
    }

    @Nullable
    public final RequestDetails getRequestDetails() {
        return this.extractValueAsObject("gatewayRequestDetails", RequestDetails.class);
    }

    public final boolean hasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    @NotNull
    public final String component1() {
        return this.json;
    }

    @NotNull
    public final Map<String, List<String>> component2() {
        return this.headers;
    }

    private final ObjectMapper component3() {
        return this.mapper;
    }

    @NotNull
    public final GraphQLResponse copy(@Language(value="json") @NotNull String json, @NotNull Map<String, ? extends List<String>> headers, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        return new GraphQLResponse(json, headers, mapper);
    }

    public static /* synthetic */ GraphQLResponse copy$default(GraphQLResponse graphQLResponse, String string, Map map, ObjectMapper objectMapper, int n, Object object) {
        if ((n & 1) != 0) {
            string = graphQLResponse.json;
        }
        if ((n & 2) != 0) {
            map = graphQLResponse.headers;
        }
        if ((n & 4) != 0) {
            objectMapper = graphQLResponse.mapper;
        }
        return graphQLResponse.copy(string, map, objectMapper);
    }

    @NotNull
    public String toString() {
        return "GraphQLResponse(json=" + this.json + ", headers=" + this.headers + ", mapper=" + this.mapper + ")";
    }

    public int hashCode() {
        int result = this.json.hashCode();
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.mapper.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphQLResponse)) {
            return false;
        }
        GraphQLResponse graphQLResponse = (GraphQLResponse)other;
        if (!Intrinsics.areEqual((Object)this.json, (Object)graphQLResponse.json)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, graphQLResponse.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mapper, (Object)graphQLResponse.mapper);
    }

    private static final Unit DEFAULT_MAPPER$lambda$1$lambda$0(KotlinModule.Builder $this$kotlinModule) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinModule, (String)"$this$kotlinModule");
        $this$kotlinModule.enable(KotlinFeature.NullIsSameAsDefault);
        return Unit.INSTANCE;
    }

    private static final Unit DEFAULT_MAPPER$lambda$1(JsonMapper.Builder $this$jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonMapper, (String)"$this$jsonMapper");
        $this$jsonMapper.addModule((Module)ExtensionsKt.kotlinModule(GraphQLResponse::DEFAULT_MAPPER$lambda$1$lambda$0));
        $this$jsonMapper.addModule((Module)new JavaTimeModule());
        $this$jsonMapper.addModule((Module)new ParameterNamesModule());
        $this$jsonMapper.addModule((Module)new Jdk8Module());
        DeserializationFeature[] deserializationFeatureArray = new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE};
        $this$jsonMapper.enable(deserializationFeatureArray);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LoggerFactory.getLogger(GraphQLResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        GraphQLResponse.logger = logger;
        DEFAULT_MAPPER = (ObjectMapper)ExtensionsKt.jsonMapper(GraphQLResponse::DEFAULT_MAPPER$lambda$1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "DEFAULT_MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDEFAULT_MAPPER$graphql_dgs_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDataPath", "", "path", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getDEFAULT_MAPPER$graphql_dgs_client() {
            return DEFAULT_MAPPER;
        }

        @NotNull
        public final String getDataPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)path, (Object)"data") || StringsKt.startsWith$default((String)path, (String)"data.", (boolean)false, (int)2, null) ? path : "data." + path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

