/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.types.subscription.OperationMessage;
import graphql.GraphQLException;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR4\u0010\r\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR4\u0010\u000e\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000f0\u000f \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;", "", "url", "", "client", "Lorg/springframework/web/reactive/socket/client/WebSocketClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;)V", "incomingSink", "Lreactor/core/publisher/Sinks$Many;", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "kotlin.jvm.PlatformType", "Lreactor/core/publisher/Sinks$Many;", "outgoingSink", "errorSink", "Lgraphql/GraphQLException;", "connect", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "send", "", "message", "receive", "Lreactor/core/publisher/Flux;", "exchange", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "createMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "decodeMessage", "Companion", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nWebSocketGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketGraphQLClient.kt\ncom/netflix/graphql/dgs/client/OperationMessageWebSocketClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,284:1\n51#2:285\n*S KotlinDebug\n*F\n+ 1 WebSocketGraphQLClient.kt\ncom/netflix/graphql/dgs/client/OperationMessageWebSocketClient\n*L\n279#1:285\n*E\n"})
public final class OperationMessageWebSocketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final WebSocketClient client;
    private final Sinks.Many<OperationMessage> incomingSink;
    private final Sinks.Many<OperationMessage> outgoingSink;
    private final Sinks.Many<GraphQLException> errorSink;
    @NotNull
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper();

    public OperationMessageWebSocketClient(@NotNull String url, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.url = url;
        this.client = client;
        this.incomingSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.outgoingSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.errorSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
    }

    @NotNull
    public final Mono<Void> connect() {
        Mono mono = Mono.defer(() -> OperationMessageWebSocketClient.connect$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    public final void send(@NotNull OperationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.outgoingSink.tryEmitNext((Object)message).orThrow();
    }

    @NotNull
    public final Flux<OperationMessage> receive() {
        Flux flux = this.incomingSink.asFlux().mergeWith((Publisher)this.errorSink.asFlux().map(arg_0 -> OperationMessageWebSocketClient.receive$lambda$2(OperationMessageWebSocketClient::receive$lambda$1, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"mergeWith(...)");
        return flux;
    }

    private final Mono<Void> exchange(WebSocketSession session) {
        Flux incomingDeserialized2 = session.receive().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$3((Function1)new Function1<WebSocketMessage, OperationMessage>((Object)this){

            public final OperationMessage invoke(WebSocketMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OperationMessageWebSocketClient.access$decodeMessage((OperationMessageWebSocketClient)this.receiver, p0);
            }
        }, arg_0)).doOnNext(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$4((Function1)new Function1<OperationMessage, Unit>(this.incomingSink){

            public final void invoke(OperationMessage p0) {
                ((Sinks.Many)this.receiver).tryEmitNext((Object)p0);
            }
        }, arg_0));
        Mono outgoingSerialized = session.send((Publisher)this.outgoingSink.asFlux().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$6(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$5(this, session, arg_0), arg_0)));
        Publisher[] publisherArray = new Publisher[]{incomingDeserialized2, outgoingSerialized};
        Mono mono = Flux.merge((Publisher[])publisherArray).then().doOnError(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$8(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$7(this, arg_0), arg_0)).doAfterTerminate(() -> OperationMessageWebSocketClient.exchange$lambda$9(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doAfterTerminate(...)");
        return mono;
    }

    private final WebSocketMessage createMessage(WebSocketSession session, OperationMessage message) {
        WebSocketMessage webSocketMessage = session.textMessage(MAPPER.writeValueAsString((Object)message));
        Intrinsics.checkNotNullExpressionValue((Object)webSocketMessage, (String)"textMessage(...)");
        return webSocketMessage;
    }

    private final OperationMessage decodeMessage(WebSocketMessage message) {
        String messageText = message.getPayloadAsText();
        boolean $i$f$jacksonTypeRef = false;
        TypeReference type = (TypeReference)new TypeReference<OperationMessage>(){};
        Object object = MAPPER.readValue(messageText, type);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (OperationMessage)object;
    }

    private static final Mono connect$lambda$0(OperationMessageWebSocketClient this$0) {
        return this$0.client.execute(new URI(this$0.url), new WebSocketHandler(this$0){
            final /* synthetic */ OperationMessageWebSocketClient this$0;
            {
                this.this$0 = $receiver;
            }

            public Mono<Void> handle(WebSocketSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                return OperationMessageWebSocketClient.access$exchange(this.this$0, session);
            }

            public List<String> getSubProtocols() {
                return CollectionsKt.listOf((Object)"graphql-ws");
            }
        });
    }

    private static final OperationMessage receive$lambda$1(GraphQLException it) {
        throw it;
    }

    private static final OperationMessage receive$lambda$2(Function1 $tmp0, Object p0) {
        return (OperationMessage)$tmp0.invoke(p0);
    }

    private static final OperationMessage exchange$lambda$3(Function1 $tmp0, Object p0) {
        return (OperationMessage)$tmp0.invoke(p0);
    }

    private static final void exchange$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final WebSocketMessage exchange$lambda$5(OperationMessageWebSocketClient this$0, WebSocketSession $session, OperationMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.createMessage($session, it);
    }

    private static final WebSocketMessage exchange$lambda$6(Function1 $tmp0, Object p0) {
        return (WebSocketMessage)$tmp0.invoke(p0);
    }

    private static final Unit exchange$lambda$7(OperationMessageWebSocketClient this$0, Throwable it) {
        this$0.errorSink.tryEmitNext((Object)new GraphQLException(it)).orThrow();
        return Unit.INSTANCE;
    }

    private static final void exchange$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void exchange$lambda$9(OperationMessageWebSocketClient this$0) {
        this$0.errorSink.tryEmitNext((Object)new GraphQLException("Server closed the connection unexpectedly")).orThrow();
    }

    public static final /* synthetic */ OperationMessage access$decodeMessage(OperationMessageWebSocketClient $this, WebSocketMessage message) {
        return $this.decodeMessage(message);
    }

    public static final /* synthetic */ Mono access$exchange(OperationMessageWebSocketClient $this, WebSocketSession session) {
        return $this.exchange(session);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient$Companion;", "", "<init>", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

