/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J0\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/client/RestClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "restClient", "Lorg/springframework/web/client/RestClient;", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "(Lorg/springframework/web/client/RestClient;)V", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;)V", "(Lorg/springframework/web/client/RestClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class RestClientGraphQLClient
implements GraphQLClient {
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;
    @NotNull
    private final ObjectMapper mapper;

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.restClient = restClient;
        this.headersConsumer = headersConsumer;
        this.mapper = mapper;
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this(restClient, RestClientGraphQLClient::_init_$lambda$0);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this(restClient, headersConsumer, GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client());
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this(restClient, RestClientGraphQLClient::_init_$lambda$1, mapper);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.executeQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.executeQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = this.mapper.writeValueAsString(GraphQLClients.INSTANCE.toRequestMap$graphql_dgs_client(query, operationName, variables));
        ResponseEntity responseEntity = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().headers(RestClientGraphQLClient::executeQuery$lambda$2)).headers(this.headersConsumer)).body((Object)serializedRequest).retrieve().toEntity(String.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            int n = responseEntity.getStatusCode().value();
            String string = (String)responseEntity.getBody();
            if (string == null) {
                string = "";
            }
            Intrinsics.checkNotNull((Object)serializedRequest);
            throw new GraphQLClientException(n, "", string, serializedRequest);
        }
        String string = (String)responseEntity.getBody();
        if (string == null) {
            string = "";
        }
        HttpHeaders httpHeaders = responseEntity.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        return new GraphQLResponse(string, (Map)httpHeaders);
    }

    private static final void _init_$lambda$0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$1(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void executeQuery$lambda$2(HttpHeaders headers) {
        headers.addAll((MultiValueMap)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client());
    }
}

