/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.types.subscription.QueryPayload;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Deprecated(message="This client uses the obsolete subscriptions-transport-sse protocol. Use GraphqlSSESubscriptionGraphQLClient to use the newer graphql-sse spec https://github.com/graphql/graphql-over-http/blob/d51ae80d62b5fd8802a3383793f01bdf306e8290/rfcs/GraphQLOverSSE.md.", replaceWith=@ReplaceWith(expression="GraphqlSSESubscriptionGraphQLClient", imports={}), level=DeprecationLevel.WARNING)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J6\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\b\u0001\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/client/SSESubscriptionGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "url", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "reactiveExecuteQuery", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "encodeQuery", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nSSESubscriptionGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSESubscriptionGraphQLClient.kt\ncom/netflix/graphql/dgs/client/SSESubscriptionGraphQLClient\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n*L\n1#1,76:1\n207#2:77\n*S KotlinDebug\n*F\n+ 1 SSESubscriptionGraphQLClient.kt\ncom/netflix/graphql/dgs/client/SSESubscriptionGraphQLClient\n*L\n64#1:77\n*E\n"})
public final class SSESubscriptionGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final ObjectMapper mapper;

    public SSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.url = url;
        this.webClient = webClient;
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        void $this$toEntityFlux$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        QueryPayload queryPayload = new QueryPayload(variables, MapsKt.emptyMap(), operationName, query, null, 16, null);
        String jsonPayload = this.mapper.writeValueAsString((Object)queryPayload);
        WebClient.RequestHeadersUriSpec requestHeadersUriSpec = this.webClient.get();
        String string = this.url + "?query={query}";
        Intrinsics.checkNotNull((Object)jsonPayload);
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_EVENT_STREAM};
        WebClient.ResponseSpec responseSpec = requestHeadersUriSpec.uri(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)this.encodeQuery(jsonPayload)))).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        boolean $i$f$toEntityFlux = false;
        Mono mono = $this$toEntityFlux$iv.toEntityFlux((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"toEntityFlux(object : Pa\u2026zedTypeReference<T>() {})");
        Flux flux = mono.flatMapMany(arg_0 -> SSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$3(SSESubscriptionGraphQLClient::reactiveExecuteQuery$lambda$2, arg_0)).publishOn(Schedulers.single());
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"publishOn(...)");
        return flux;
    }

    private final String encodeQuery(@Language(value="graphql") String query) {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = query;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return encoder.encodeToString(byArray);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$2$lambda$0(HttpHeaders $headers, String body) {
        Intrinsics.checkNotNull((Object)body);
        Intrinsics.checkNotNull((Object)$headers);
        return new GraphQLResponse(body, (Map)$headers);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (GraphQLResponse)$tmp0.invoke(p0);
    }

    private static final Publisher reactiveExecuteQuery$lambda$2(ResponseEntity response) {
        HttpHeaders headers = response.getHeaders();
        Flux flux = (Flux)response.getBody();
        return flux != null && (flux = flux.map(arg_0 -> SSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$2$lambda$1(arg_0 -> SSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$2$lambda$0(headers, arg_0), arg_0))) != null ? (Publisher)flux : (Publisher)Flux.empty();
    }

    private static final Publisher reactiveExecuteQuery$lambda$3(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }
}

