/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J<\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "webclient", "Lorg/springframework/web/reactive/function/client/WebClient;", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lorg/springframework/web/reactive/function/client/WebClient;Ljava/util/function/Consumer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "(Lorg/springframework/web/reactive/function/client/WebClient;)V", "(Lorg/springframework/web/reactive/function/client/WebClient;Ljava/util/function/Consumer;)V", "(Lorg/springframework/web/reactive/function/client/WebClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "", "variables", "", "", "operationName", "requestBodyUriCustomizer", "Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$RequestBodyUriCustomizer;", "handleResponse", "response", "Lorg/springframework/http/ResponseEntity;", "requestBody", "Companion", "RequestBodyUriCustomizer", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nWebClientGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebClientGraphQLClient.kt\ncom/netflix/graphql/dgs/client/WebClientGraphQLClient\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n*L\n1#1,170:1\n187#2:171\n*S KotlinDebug\n*F\n+ 1 WebClientGraphQLClient.kt\ncom/netflix/graphql/dgs/client/WebClientGraphQLClient\n*L\n126#1:171\n*E\n"})
public final class WebClientGraphQLClient
implements MonoGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebClient webclient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private static final RequestBodyUriCustomizer REQUEST_BODY_URI_CUSTOMIZER_IDENTITY = WebClientGraphQLClient::REQUEST_BODY_URI_CUSTOMIZER_IDENTITY$lambda$5;

    public WebClientGraphQLClient(@NotNull WebClient webclient, @NotNull Consumer<HttpHeaders> headersConsumer, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.webclient = webclient;
        this.headersConsumer = headersConsumer;
        this.mapper = mapper;
    }

    public WebClientGraphQLClient(@NotNull WebClient webclient) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        this(webclient, WebClientGraphQLClient::_init_$lambda$0);
    }

    public WebClientGraphQLClient(@NotNull WebClient webclient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this(webclient, headersConsumer, GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client());
    }

    public WebClientGraphQLClient(@NotNull WebClient webclient, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this(webclient, WebClientGraphQLClient::_init_$lambda$1, mapper);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, operationName, REQUEST_BODY_URI_CUSTOMIZER_IDENTITY);
    }

    @NotNull
    public final Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull RequestBodyUriCustomizer requestBodyUriCustomizer) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)requestBodyUriCustomizer, (String)"requestBodyUriCustomizer");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), null, requestBodyUriCustomizer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull RequestBodyUriCustomizer requestBodyUriCustomizer) {
        void $this$toEntity$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestBodyUriCustomizer, (String)"requestBodyUriCustomizer");
        String serializedRequest = this.mapper.writeValueAsString(GraphQLClients.INSTANCE.toRequestMap$graphql_dgs_client(query, operationName, variables));
        WebClient.RequestBodyUriSpec requestBodyUriSpec = this.webclient.post();
        Intrinsics.checkNotNullExpressionValue((Object)requestBodyUriSpec, (String)"post(...)");
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)requestBodyUriCustomizer.apply(requestBodyUriSpec).headers(WebClientGraphQLClient::reactiveExecuteQuery$lambda$2)).headers(this.headersConsumer)).bodyValue((Object)serializedRequest).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        boolean $i$f$toEntity = false;
        Mono mono = $this$toEntity$iv.toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"toEntity(object : Parame\u2026zedTypeReference<T>() {})");
        Mono mono2 = mono.map(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda$4(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda$3(this, serializedRequest, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"map(...)");
        return mono2;
    }

    private final GraphQLResponse handleResponse(ResponseEntity<String> response, String requestBody) {
        if (!response.getStatusCode().is2xxSuccessful()) {
            int n = response.getStatusCode().value();
            String string = this.webclient.toString();
            String string2 = (String)response.getBody();
            if (string2 == null) {
                string2 = "";
            }
            throw new GraphQLClientException(n, string, string2, requestBody);
        }
        String string = (String)response.getBody();
        if (string == null) {
            string = "";
        }
        HttpHeaders httpHeaders = response.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        return new GraphQLResponse(string, (Map)httpHeaders);
    }

    private static final void _init_$lambda$0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$1(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void reactiveExecuteQuery$lambda$2(HttpHeaders headers) {
        headers.addAll((MultiValueMap)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client());
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$3(WebClientGraphQLClient this$0, String $serializedRequest, ResponseEntity httpResponse) {
        Intrinsics.checkNotNull((Object)httpResponse);
        Intrinsics.checkNotNull((Object)$serializedRequest);
        return this$0.handleResponse((ResponseEntity<String>)httpResponse, $serializedRequest);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$4(Function1 $tmp0, Object p0) {
        return (GraphQLResponse)$tmp0.invoke(p0);
    }

    private static final WebClient.RequestBodySpec REQUEST_BODY_URI_CUSTOMIZER_IDENTITY$lambda$5(WebClient.RequestBodyUriSpec it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (WebClient.RequestBodySpec)it;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$Companion;", "", "<init>", "()V", "REQUEST_BODY_URI_CUSTOMIZER_IDENTITY", "Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$RequestBodyUriCustomizer;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @FunctionalInterface
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$RequestBodyUriCustomizer;", "", "apply", "Lorg/springframework/web/reactive/function/client/WebClient$RequestBodySpec;", "spec", "Lorg/springframework/web/reactive/function/client/WebClient$RequestBodyUriSpec;", "graphql-dgs-client"})
    public static interface RequestBodyUriCustomizer {
        @NotNull
        public WebClient.RequestBodySpec apply(@NotNull WebClient.RequestBodyUriSpec var1);
    }
}

