/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010JC\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLClients;", "", "()V", "defaultHeaders", "Lorg/springframework/http/HttpHeaders;", "getDefaultHeaders$graphql_dgs_client", "()Lorg/springframework/http/HttpHeaders;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper$graphql_dgs_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "", "url", "toRequestMap", "", "query", "operationName", "variables", "toRequestMap$graphql_dgs_client", "graphql-dgs-client"})
public final class GraphQLClients {
    @NotNull
    public static final GraphQLClients INSTANCE = new GraphQLClients();
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final HttpHeaders defaultHeaders;

    private GraphQLClients() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper$graphql_dgs_client() {
        return objectMapper;
    }

    @NotNull
    public final HttpHeaders getDefaultHeaders$graphql_dgs_client() {
        return defaultHeaders;
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int statusCode = response.component1();
        String body = response.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (HttpStatusCode.valueOf((int)response.getStatusCode()).isError()) {
            String string = body;
            if (string == null) {
                string = "";
            }
            throw new GraphQLClientException(statusCode, url, string, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, headers);
    }

    @NotNull
    public final Map<String, Object> toRequestMap$graphql_dgs_client(@NotNull String query, @Nullable String operationName, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"query", (Object)query), TuplesKt.to((Object)"operationName", (Object)operationName), TuplesKt.to((Object)"variables", variables)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    static {
        HttpHeaders httpHeaders = new HttpHeaders[]{new KotlinModule.Builder().enable(KotlinFeature.NullIsSameAsDefault).build()};
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().modulesToInstall((Module[])httpHeaders).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        GraphQLClients.objectMapper = objectMapper;
        HttpHeaders $this$defaultHeaders_u24lambda_u240 = httpHeaders = new HttpHeaders();
        boolean bl = false;
        $this$defaultHeaders_u24lambda_u240.setAccept(CollectionsKt.listOf((Object)MediaType.APPLICATION_JSON));
        $this$defaultHeaders_u24lambda_u240.setContentType(MediaType.APPLICATION_JSON);
        HttpHeaders httpHeaders2 = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)httpHeaders);
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders2, (String)"readOnlyHttpHeaders(...)");
        defaultHeaders = httpHeaders2;
    }
}

