/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.RequestExecutor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0003H\u0016J&\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J0\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/client/CustomGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "url", "", "requestExecutor", "Lcom/netflix/graphql/dgs/client/RequestExecutor;", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/RequestExecutor;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/RequestExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/RequestExecutor;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/RequestExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class CustomGraphQLClient
implements GraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final RequestExecutor requestExecutor;
    @NotNull
    private final ObjectMapper mapper;
    @Nullable
    private final GraphQLRequestOptions options;

    public CustomGraphQLClient(@NotNull String url, @NotNull RequestExecutor requestExecutor, @NotNull ObjectMapper mapper, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.url = url;
        this.requestExecutor = requestExecutor;
        this.mapper = mapper;
        this.options = options;
    }

    public /* synthetic */ CustomGraphQLClient(String string, RequestExecutor requestExecutor, ObjectMapper objectMapper, GraphQLRequestOptions graphQLRequestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            graphQLRequestOptions = null;
        }
        this(string, requestExecutor, objectMapper, graphQLRequestOptions);
    }

    public CustomGraphQLClient(@NotNull String url, @NotNull RequestExecutor requestExecutor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        this(url, requestExecutor, GraphQLRequestOptions.Companion.createCustomObjectMapper());
    }

    public CustomGraphQLClient(@NotNull String url, @NotNull RequestExecutor requestExecutor, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this(url, requestExecutor, mapper, null);
    }

    public CustomGraphQLClient(@NotNull String url, @NotNull RequestExecutor requestExecutor, @NotNull GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(url, requestExecutor, GraphQLRequestOptions.Companion.createCustomObjectMapper(options), options);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.executeQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.executeQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = this.mapper.writeValueAsString(GraphQLClients.INSTANCE.toRequestMap$graphql_dgs_client(query, operationName, variables));
        Map map = (Map)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client();
        Intrinsics.checkNotNull((Object)serializedRequest);
        HttpResponse response = this.requestExecutor.execute(this.url, map, serializedRequest);
        return GraphQLClients.INSTANCE.handleResponse(response, serializedRequest, this.url, this.options);
    }
}

