/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J0\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/netflix/graphql/dgs/client/RestClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "restClient", "Lorg/springframework/web/client/RestClient;", "(Lorg/springframework/web/client/RestClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/springframework/web/client/RestClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;)V", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "(Lorg/springframework/web/client/RestClient;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class RestClientGraphQLClient
implements GraphQLClient {
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;
    @NotNull
    private final ObjectMapper mapper;
    @Nullable
    private final GraphQLRequestOptions options;

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer, @NotNull ObjectMapper mapper, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.restClient = restClient;
        this.headersConsumer = headersConsumer;
        this.mapper = mapper;
        this.options = options;
    }

    public /* synthetic */ RestClientGraphQLClient(RestClient restClient, Consumer consumer, ObjectMapper objectMapper, GraphQLRequestOptions graphQLRequestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            graphQLRequestOptions = null;
        }
        this(restClient, consumer, objectMapper, graphQLRequestOptions);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this(restClient, RestClientGraphQLClient::_init_$lambda$0);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this(restClient, RestClientGraphQLClient::_init_$lambda$1, mapper);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this(restClient, headersConsumer, GraphQLRequestOptions.Companion.createCustomObjectMapper());
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this(restClient, headersConsumer, mapper, null);
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this(restClient, RestClientGraphQLClient::_init_$lambda$2, GraphQLRequestOptions.Companion.createCustomObjectMapper(options), options);
    }

    public /* synthetic */ RestClientGraphQLClient(RestClient restClient, GraphQLRequestOptions graphQLRequestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            graphQLRequestOptions = null;
        }
        this(restClient, graphQLRequestOptions);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.executeQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.executeQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = this.mapper.writeValueAsString(GraphQLClients.INSTANCE.toRequestMap$graphql_dgs_client(query, operationName, variables));
        ResponseEntity responseEntity = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().headers(RestClientGraphQLClient::executeQuery$lambda$3)).headers(this.headersConsumer)).body((Object)serializedRequest).retrieve().toEntity(String.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            int n = responseEntity.getStatusCode().value();
            String string = (String)responseEntity.getBody();
            if (string == null) {
                string = "";
            }
            Intrinsics.checkNotNull((Object)serializedRequest);
            throw new GraphQLClientException(n, "", string, serializedRequest);
        }
        String string = (String)responseEntity.getBody();
        if (string == null) {
            string = "";
        }
        HttpHeaders httpHeaders = responseEntity.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        return new GraphQLResponse(string, (Map<String, ? extends List<String>>)((Map)httpHeaders), this.options);
    }

    private static final void _init_$lambda$0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$1(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void _init_$lambda$2(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void executeQuery$lambda$3(HttpHeaders headers) {
        headers.addAll((MultiValueMap)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client());
    }
}

