/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bJ*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015JC\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLClients;", "", "()V", "defaultHeaders", "Lorg/springframework/http/HttpHeaders;", "getDefaultHeaders$graphql_dgs_client", "()Lorg/springframework/http/HttpHeaders;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper$graphql_dgs_client$annotations", "getObjectMapper$graphql_dgs_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "", "url", "mapper", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "toRequestMap", "", "query", "operationName", "variables", "toRequestMap$graphql_dgs_client", "graphql-dgs-client"})
public final class GraphQLClients {
    @NotNull
    public static final GraphQLClients INSTANCE = new GraphQLClients();
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final HttpHeaders defaultHeaders;

    private GraphQLClients() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper$graphql_dgs_client() {
        return objectMapper;
    }

    @Deprecated(message="Use GraphQLRequestOptions.createCustomObjectMapper instead")
    public static /* synthetic */ void getObjectMapper$graphql_dgs_client$annotations() {
    }

    @NotNull
    public final HttpHeaders getDefaultHeaders$graphql_dgs_client() {
        return defaultHeaders;
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.handleResponse(response, requestBody, url, (GraphQLRequestOptions)null);
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        int statusCode = response.component1();
        String body = response.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (HttpStatusCode.valueOf((int)response.getStatusCode()).isError()) {
            String string = body;
            if (string == null) {
                string = "";
            }
            throw new GraphQLClientException(statusCode, url, string, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, headers, mapper);
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int statusCode = response.component1();
        String body = response.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (HttpStatusCode.valueOf((int)response.getStatusCode()).isError()) {
            String string = body;
            if (string == null) {
                string = "";
            }
            throw new GraphQLClientException(statusCode, url, string, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, headers, options);
    }

    public static /* synthetic */ GraphQLResponse handleResponse$default(GraphQLClients graphQLClients, HttpResponse httpResponse, String string, String string2, GraphQLRequestOptions graphQLRequestOptions, int n, Object object) {
        if ((n & 8) != 0) {
            graphQLRequestOptions = null;
        }
        return graphQLClients.handleResponse(httpResponse, string, string2, graphQLRequestOptions);
    }

    @NotNull
    public final Map<String, Object> toRequestMap$graphql_dgs_client(@NotNull String query, @Nullable String operationName, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"query", (Object)query), TuplesKt.to((Object)"operationName", (Object)operationName), TuplesKt.to((Object)"variables", variables)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    static {
        HttpHeaders httpHeaders = new HttpHeaders[]{new KotlinModule.Builder().enable(KotlinFeature.NullIsSameAsDefault).build()};
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().modulesToInstall((Module[])httpHeaders).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        GraphQLClients.objectMapper = objectMapper;
        HttpHeaders $this$defaultHeaders_u24lambda_u240 = httpHeaders = new HttpHeaders();
        boolean bl = false;
        $this$defaultHeaders_u24lambda_u240.setAccept(CollectionsKt.listOf((Object)MediaType.APPLICATION_JSON));
        $this$defaultHeaders_u24lambda_u240.setContentType(MediaType.APPLICATION_JSON);
        HttpHeaders httpHeaders2 = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)httpHeaders);
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders2, (String)"readOnlyHttpHeaders(...)");
        defaultHeaders = httpHeaders2;
    }
}

