/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.client.GraphQLRequestOptions;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.GraphqlSSESubscriptionGraphQLClient;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.types.subscription.QueryPayload;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/client/GraphqlSSESubscriptionGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "url", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "options", "Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;Lcom/netflix/graphql/dgs/client/GraphQLRequestOptions;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "reactiveExecuteQuery", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nGraphqlSSESubscriptionGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphqlSSESubscriptionGraphQLClient.kt\ncom/netflix/graphql/dgs/client/GraphqlSSESubscriptionGraphQLClient\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n*L\n1#1,81:1\n219#2:82\n*S KotlinDebug\n*F\n+ 1 GraphqlSSESubscriptionGraphQLClient.kt\ncom/netflix/graphql/dgs/client/GraphqlSSESubscriptionGraphQLClient\n*L\n64#1:82\n*E\n"})
public final class GraphqlSSESubscriptionGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final WebClient webClient;
    @Nullable
    private final GraphQLRequestOptions options;
    @NotNull
    private final ObjectMapper mapper;

    public GraphqlSSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient, @Nullable GraphQLRequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.url = url;
        this.webClient = webClient;
        this.options = options;
        this.mapper = GraphQLRequestOptions.Companion.createCustomObjectMapper(this.options);
    }

    public /* synthetic */ GraphqlSSESubscriptionGraphQLClient(String string, WebClient webClient, GraphQLRequestOptions graphQLRequestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            graphQLRequestOptions = null;
        }
        this(string, webClient, graphQLRequestOptions);
    }

    public GraphqlSSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this(url, webClient, null);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        void $this$toEntityFlux$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        QueryPayload queryPayload = new QueryPayload(variables, MapsKt.emptyMap(), operationName, query, null, 16, null);
        String jsonPayload = this.mapper.writeValueAsString((Object)queryPayload);
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_EVENT_STREAM};
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri(this.url, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)jsonPayload).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        WebClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$toEntityFlux = false;
        Mono mono = $this$toEntityFlux$iv.toEntityFlux((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"toEntityFlux(object : Pa\u2026zedTypeReference<T>() {})");
        Disposable dis2 = mono.flatMapMany(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$0((Function1)new Function1<ResponseEntity<Flux<String>>, Publisher<? extends Sinks.EmitResult>>((Sinks.Many<GraphQLResponse>)sink, this){
            final /* synthetic */ Sinks.Many<GraphQLResponse> $sink;
            final /* synthetic */ GraphqlSSESubscriptionGraphQLClient this$0;
            {
                this.$sink = $sink;
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends Sinks.EmitResult> invoke(ResponseEntity<Flux<String>> it) {
                HttpHeaders headers = it.getHeaders();
                Flux flux = (Flux)it.getBody();
                return flux != null && (flux = flux.map(arg_0 -> reactiveExecuteQuery.dis.1.invoke$lambda$0((Function1)new Function1<String, Sinks.EmitResult>(this.$sink, headers, this.this$0){
                    final /* synthetic */ Sinks.Many<GraphQLResponse> $sink;
                    final /* synthetic */ HttpHeaders $headers;
                    final /* synthetic */ GraphqlSSESubscriptionGraphQLClient this$0;
                    {
                        this.$sink = $sink;
                        this.$headers = $headers;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Sinks.EmitResult invoke(String serverSentEvent) {
                        Intrinsics.checkNotNull((Object)serverSentEvent);
                        HttpHeaders httpHeaders = this.$headers;
                        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"$headers");
                        return this.$sink.tryEmitNext((Object)new GraphQLResponse(serverSentEvent, (Map<String, ? extends List<String>>)((Map)httpHeaders), GraphqlSSESubscriptionGraphQLClient.access$getMapper$p(this.this$0)));
                    }
                }, arg_0))) != null ? (Publisher)flux : (Publisher)Flux.empty();
            }

            private static final Sinks.EmitResult invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Sinks.EmitResult)$tmp0.invoke(p0);
            }
        }, arg_0)).onErrorResume(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$1((Function1)new Function1<Throwable, Publisher<? extends Sinks.EmitResult>>((Sinks.Many<GraphQLResponse>)sink){
            final /* synthetic */ Sinks.Many<GraphQLResponse> $sink;
            {
                this.$sink = $sink;
                super(1);
            }

            public final Publisher<? extends Sinks.EmitResult> invoke(Throwable it) {
                return (Publisher)Flux.just((Object)this.$sink.tryEmitError(it));
            }
        }, arg_0)).doFinally(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$2(sink, arg_0)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Flux flux = sink.asFlux().publishOn(Schedulers.single()).doFinally(arg_0 -> GraphqlSSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda$3(dis2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doFinally(...)");
        return flux;
    }

    private static final Publisher reactiveExecuteQuery$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher reactiveExecuteQuery$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void reactiveExecuteQuery$lambda$2(Sinks.Many $sink, SignalType it) {
        $sink.tryEmitComplete();
    }

    private static final void reactiveExecuteQuery$lambda$3(Disposable $dis, SignalType it) {
        $dis.dispose();
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(GraphqlSSESubscriptionGraphQLClient $this) {
        return $this.mapper;
    }
}

