/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.OperationMessageWebSocketClient;
import com.netflix.graphql.types.subscription.OperationMessage;
import graphql.GraphQLException;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;", "", "url", "", "client", "Lorg/springframework/web/reactive/socket/client/WebSocketClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;)V", "incomingSink", "Lreactor/core/publisher/Sinks$Many;", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "Lkotlin/jvm/internal/EnhancedNullability;", "outgoingSink", "errorSink", "Lgraphql/GraphQLException;", "connect", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "send", "", "message", "receive", "Lreactor/core/publisher/Flux;", "exchange", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "createMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "decodeMessage", "Companion", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nWebSocketGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketGraphQLClient.kt\ncom/netflix/graphql/dgs/client/OperationMessageWebSocketClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,295:1\n54#2:296\n*S KotlinDebug\n*F\n+ 1 WebSocketGraphQLClient.kt\ncom/netflix/graphql/dgs/client/OperationMessageWebSocketClient\n*L\n290#1:296\n*E\n"})
public final class OperationMessageWebSocketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final WebSocketClient client;
    @NotNull
    private final Sinks.Many<OperationMessage> incomingSink;
    @NotNull
    private final Sinks.Many<OperationMessage> outgoingSink;
    @NotNull
    private final Sinks.Many<GraphQLException> errorSink;
    @NotNull
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper();

    public OperationMessageWebSocketClient(@NotNull String url, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.url = url;
        this.client = client;
        Sinks.Many many = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.incomingSink = many;
        Sinks.Many many2 = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        Intrinsics.checkNotNullExpressionValue((Object)many2, (String)"onBackpressureBuffer(...)");
        this.outgoingSink = many2;
        Sinks.Many many3 = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        Intrinsics.checkNotNullExpressionValue((Object)many3, (String)"onBackpressureBuffer(...)");
        this.errorSink = many3;
    }

    @NotNull
    public final Mono<Void> connect() {
        Mono mono = Mono.defer(() -> OperationMessageWebSocketClient.connect$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    public final void send(@NotNull OperationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.outgoingSink.tryEmitNext((Object)message).orThrow();
    }

    @NotNull
    public final Flux<OperationMessage> receive() {
        Function1 function1 = receive.1.INSTANCE;
        Flux flux = this.incomingSink.asFlux().mergeWith((Publisher)this.errorSink.asFlux().map(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"mergeWith(...)");
        return flux;
    }

    private final Mono<Void> exchange(WebSocketSession session) {
        Flux flux = session.receive().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$0((Function1)new Function1<WebSocketMessage, OperationMessage>((Object)this){

            public final OperationMessage invoke(WebSocketMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OperationMessageWebSocketClient.access$decodeMessage((OperationMessageWebSocketClient)this.receiver, p0);
            }
        }, arg_0)).doOnNext(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$1((Function1)new Function1<OperationMessage, Unit>(this.incomingSink){

            public final void invoke(OperationMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((Sinks.Many)this.receiver).tryEmitNext((Object)p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doOnNext(...)");
        Flux incomingDeserialized2 = flux;
        Mono mono = session.send((Publisher)this.outgoingSink.asFlux().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$3(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$2(this, session, arg_0), arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"send(...)");
        Mono outgoingSerialized = mono;
        Publisher[] publisherArray = new Publisher[]{incomingDeserialized2, outgoingSerialized};
        mono = Flux.merge((Publisher[])publisherArray).then().doOnError(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$5(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$4(this, arg_0), arg_0)).doAfterTerminate(() -> OperationMessageWebSocketClient.exchange$lambda$6(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doAfterTerminate(...)");
        return mono;
    }

    private final WebSocketMessage createMessage(WebSocketSession session, OperationMessage message) {
        WebSocketMessage webSocketMessage = session.textMessage(MAPPER.writeValueAsString((Object)message));
        Intrinsics.checkNotNullExpressionValue((Object)webSocketMessage, (String)"textMessage(...)");
        return webSocketMessage;
    }

    private final OperationMessage decodeMessage(WebSocketMessage message) {
        String string = message.getPayloadAsText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPayloadAsText(...)");
        String messageText = string;
        boolean $i$f$jacksonTypeRef = false;
        TypeReference type = (TypeReference)new TypeReference<OperationMessage>(){};
        Object object = MAPPER.readValue(messageText, type);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (OperationMessage)object;
    }

    private static final Mono connect$lambda$0(OperationMessageWebSocketClient this$0) {
        return this$0.client.execute(new URI(this$0.url), new WebSocketHandler(this$0){
            final /* synthetic */ OperationMessageWebSocketClient this$0;
            {
                this.this$0 = $receiver;
            }

            public Mono<Void> handle(WebSocketSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                return OperationMessageWebSocketClient.access$exchange(this.this$0, session);
            }

            public List<String> getSubProtocols() {
                return CollectionsKt.listOf((Object)"graphql-ws");
            }
        });
    }

    private static final OperationMessage exchange$lambda$0(Function1 $tmp0, Object p0) {
        return (OperationMessage)$tmp0.invoke(p0);
    }

    private static final void exchange$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final WebSocketMessage exchange$lambda$2(OperationMessageWebSocketClient this$0, WebSocketSession $session, OperationMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createMessage($session, it);
    }

    private static final WebSocketMessage exchange$lambda$3(Function1 $tmp0, Object p0) {
        return (WebSocketMessage)$tmp0.invoke(p0);
    }

    private static final Unit exchange$lambda$4(OperationMessageWebSocketClient this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.errorSink.tryEmitNext((Object)new GraphQLException(it)).orThrow();
        return Unit.INSTANCE;
    }

    private static final void exchange$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void exchange$lambda$6(OperationMessageWebSocketClient this$0) {
        this$0.errorSink.tryEmitNext((Object)new GraphQLException("Server closed the connection unexpectedly")).orThrow();
    }

    public static final /* synthetic */ OperationMessage access$decodeMessage(OperationMessageWebSocketClient $this, WebSocketMessage message) {
        return $this.decodeMessage(message);
    }

    public static final /* synthetic */ Mono access$exchange(OperationMessageWebSocketClient $this, WebSocketSession session) {
        return $this.exchange(session);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient$Companion;", "", "<init>", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

