/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.OperationMessageWebSocketClient;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.types.subscription.OperationMessage;
import com.netflix.graphql.types.subscription.QueryPayload;
import graphql.GraphQLException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated(message="This client is using the deprecated subscription-transport-ws protocol, which is no longer supported by DGS servers. Use Spring GraphQL WebSocketGraphQlClient instead. https://docs.spring.io/spring-graphql/reference/client.html#client.websocketgraphqlclient", level=DeprecationLevel.WARNING)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u000eJ,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0001\u0010\u001b\u001a\u00020\t2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0001\u0010\u001b\u001a\u00020\t2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/netflix/graphql/dgs/client/WebSocketGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "client", "Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;", "acknowledgementTimeout", "Ljava/time/Duration;", "<init>", "(Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;Ljava/time/Duration;)V", "url", "", "Lorg/springframework/web/reactive/socket/client/WebSocketClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;Ljava/time/Duration;)V", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;)V", "(Ljava/lang/String;)V", "(Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;)V", "subscriptionCount", "Ljava/util/concurrent/atomic/AtomicLong;", "connection", "Ljava/util/concurrent/atomic/AtomicReference;", "Lreactor/core/Disposable;", "handshake", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "Lkotlin/jvm/internal/EnhancedNullability;", "reactiveExecuteQuery", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "connectionIsStale", "", "doHandshake", "handleMessage", "message", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "Companion", "graphql-dgs-client"})
public final class WebSocketGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OperationMessageWebSocketClient client;
    @NotNull
    private final Duration acknowledgementTimeout;
    @NotNull
    private final AtomicLong subscriptionCount;
    @NotNull
    private final AtomicReference<Disposable> connection;
    @NotNull
    private final Mono<Void> handshake;
    private static final Duration DEFAULT_ACKNOWLEDGEMENT_TIMEOUT = Duration.ofSeconds(30L);
    @NotNull
    private static final OperationMessage CONNECTION_INIT_MESSAGE = new OperationMessage("connection_init", null, null);
    @NotNull
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper();

    public WebSocketGraphQLClient(@NotNull OperationMessageWebSocketClient client, @NotNull Duration acknowledgementTimeout) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)acknowledgementTimeout, (String)"acknowledgementTimeout");
        this.client = client;
        this.acknowledgementTimeout = acknowledgementTimeout;
        this.subscriptionCount = new AtomicLong(0L);
        this.connection = new AtomicReference<Object>(null);
        Mono mono = Mono.defer(() -> WebSocketGraphQLClient.handshake$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        this.handshake = mono;
    }

    public /* synthetic */ WebSocketGraphQLClient(OperationMessageWebSocketClient operationMessageWebSocketClient, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
            duration = duration2;
        }
        this(operationMessageWebSocketClient, duration);
    }

    public WebSocketGraphQLClient(@NotNull String url, @NotNull WebSocketClient client, @NotNull Duration acknowledgementTimeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)acknowledgementTimeout, (String)"acknowledgementTimeout");
        this(new OperationMessageWebSocketClient(url, client), acknowledgementTimeout);
    }

    public WebSocketGraphQLClient(@NotNull String url, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        OperationMessageWebSocketClient operationMessageWebSocketClient = new OperationMessageWebSocketClient(url, client);
        Duration duration = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
        this(operationMessageWebSocketClient, duration);
    }

    public WebSocketGraphQLClient(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        OperationMessageWebSocketClient operationMessageWebSocketClient = new OperationMessageWebSocketClient(url, (WebSocketClient)new ReactorNettyWebSocketClient());
        Duration duration = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
        this(operationMessageWebSocketClient, duration);
    }

    public WebSocketGraphQLClient(@NotNull OperationMessageWebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Duration duration = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
        this(client, duration);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String subscriptionId = String.valueOf(this.subscriptionCount.incrementAndGet());
        OperationMessage queryMessage = new OperationMessage("start", (Object)new QueryPayload(variables, MapsKt.emptyMap(), operationName, query, null, 16, null), subscriptionId);
        OperationMessage stopMessage = new OperationMessage("stop", null, subscriptionId);
        Flux flux = this.handshake.then(Mono.fromRunnable(() -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$0(this, queryMessage))).thenMany((Publisher)this.client.receive().filter(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$2(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$1(subscriptionId, arg_0), arg_0)).takeUntil(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$4(WebSocketGraphQLClient::reactiveExecuteQuery$lambda$3, arg_0)).doOnCancel(() -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$5(this, stopMessage)).flatMap(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$6((Function1)new Function1<OperationMessage, Flux<GraphQLResponse>>((Object)this){

            public final Flux<GraphQLResponse> invoke(OperationMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return WebSocketGraphQLClient.access$handleMessage((WebSocketGraphQLClient)this.receiver, p0);
            }
        }, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"thenMany(...)");
        return flux;
    }

    private final boolean connectionIsStale() {
        Disposable disposable = this.connection.get();
        return !(disposable != null ? !disposable.isDisposed() : false);
    }

    private final Mono<Void> doHandshake() {
        Mono mono = Mono.defer(() -> WebSocketGraphQLClient.doHandshake$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    private final Flux<GraphQLResponse> handleMessage(OperationMessage message) {
        switch (message.getType()) {
            case "connection_ack": 
            case "ka": 
            case "complete": {
                Flux flux = Flux.empty();
                Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"empty(...)");
                return flux;
            }
            case "data": {
                Object payload = message.getPayload();
                String string = MAPPER.writeValueAsString(payload);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                Flux flux = Flux.just((Object)new GraphQLResponse(string));
                Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(...)");
                return flux;
            }
            case "connection_error": 
            case "error": {
                String errorMessage = String.valueOf(message.getPayload());
                throw new GraphQLException(errorMessage);
            }
        }
        throw new GraphQLException("Unable to handle message of type " + message.getType() + ". Full message: " + message);
    }

    private static final Mono handshake$lambda$0(WebSocketGraphQLClient this$0) {
        Mono mono;
        if (this$0.connectionIsStale()) {
            mono = this$0.doHandshake();
        } else {
            Mono mono2 = Mono.empty();
            Intrinsics.checkNotNull((Object)mono2);
            mono = mono2;
        }
        return mono;
    }

    private static final void reactiveExecuteQuery$lambda$0(WebSocketGraphQLClient this$0, OperationMessage $queryMessage) {
        this$0.client.send($queryMessage);
    }

    private static final boolean reactiveExecuteQuery$lambda$1(String $subscriptionId, OperationMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$subscriptionId);
    }

    private static final boolean reactiveExecuteQuery$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reactiveExecuteQuery$lambda$3(OperationMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)"complete");
    }

    private static final boolean reactiveExecuteQuery$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void reactiveExecuteQuery$lambda$5(WebSocketGraphQLClient this$0, OperationMessage $stopMessage) {
        this$0.client.send($stopMessage);
    }

    private static final Publisher reactiveExecuteQuery$lambda$6(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono doHandshake$lambda$0(WebSocketGraphQLClient this$0) {
        this$0.connection.set(this$0.client.connect().subscribe());
        this$0.client.send(CONNECTION_INIT_MESSAGE);
        return this$0.client.receive().take(1L).map(arg_0 -> WebSocketGraphQLClient.doHandshake$lambda$0$1(WebSocketGraphQLClient::doHandshake$lambda$0$0, arg_0)).timeout(this$0.acknowledgementTimeout).then();
    }

    private static final OperationMessage doHandshake$lambda$0$0(OperationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!Intrinsics.areEqual((Object)message.getType(), (Object)"connection_ack")) {
            throw new GraphQLException("Acknowledgement expected from server, received " + message);
        }
        return message;
    }

    private static final OperationMessage doHandshake$lambda$0$1(Function1 $tmp0, Object p0) {
        return (OperationMessage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Flux access$handleMessage(WebSocketGraphQLClient $this, OperationMessage message) {
        return $this.handleMessage(message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/client/WebSocketGraphQLClient$Companion;", "", "<init>", "()V", "DEFAULT_ACKNOWLEDGEMENT_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "CONNECTION_INIT_MESSAGE", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

