/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.MonoRequestExecutor;
import com.netflix.graphql.dgs.client.RequestExecutor;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0015H\u0016J<\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/client/DefaultGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "url", "", "(Ljava/lang/String;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "requestExecutor", "Lcom/netflix/graphql/dgs/client/RequestExecutor;", "operationName", "handleResponse", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "Lcom/netflix/graphql/dgs/client/MonoRequestExecutor;", "Companion", "graphql-dgs-client"})
public final class DefaultGraphQLClient
implements GraphQLClient,
MonoGraphQLClient {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String url;
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final Map<String, List<String>> defaultHeaders;

    public DefaultGraphQLClient(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull RequestExecutor requestExecutor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        String serializedRequest = objectMapper.writeValueAsString((Object)new Companion.Request(query, variables, operationName));
        Intrinsics.checkNotNullExpressionValue((Object)serializedRequest, (String)"serializedRequest");
        HttpResponse response = requestExecutor.execute(this.url, defaultHeaders, serializedRequest);
        return this.handleResponse(response, serializedRequest);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull RequestExecutor requestExecutor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        return this.executeQuery(query, variables, null, requestExecutor);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull MonoRequestExecutor requestExecutor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        return this.reactiveExecuteQuery(query, variables, null, requestExecutor);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull MonoRequestExecutor requestExecutor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        String serializedRequest = objectMapper.writeValueAsString((Object)new Companion.Request(query, variables, operationName));
        Intrinsics.checkNotNullExpressionValue((Object)serializedRequest, (String)"serializedRequest");
        Mono mono = requestExecutor.execute(this.url, defaultHeaders, serializedRequest).map(arg_0 -> DefaultGraphQLClient.reactiveExecuteQuery$lambda-0(this, serializedRequest, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"requestExecutor.execute(url, defaultHeaders, serializedRequest).map { response ->\n            handleResponse(response, serializedRequest)\n        }");
        return mono;
    }

    private final GraphQLResponse handleResponse(HttpResponse response, String requestBody) {
        HttpResponse httpResponse = response;
        int statusCode = httpResponse.component1();
        String body = httpResponse.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (!(200 <= statusCode ? statusCode <= 299 : false)) {
            String string = body;
            throw new GraphQLClientException(statusCode, this.url, string == null ? "" : string, requestBody);
        }
        String string = body;
        return new GraphQLResponse(string == null ? "" : string, headers);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda-0(DefaultGraphQLClient this$0, String $serializedRequest, HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        Intrinsics.checkNotNullExpressionValue((Object)$serializedRequest, (String)"serializedRequest");
        return this$0.handleResponse(response, $serializedRequest);
    }

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        try {
            Class.forName("com.fasterxml.jackson.module.kotlin.KotlinModule$Builder");
            objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().nullIsSameAsDefault(true).build());
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"{\n            Class.forName(\"com.fasterxml.jackson.module.kotlin.KotlinModule\\$Builder\")\n            ObjectMapper().registerModule(KotlinModule.Builder().nullIsSameAsDefault(true).build())\n        }");
        }
        catch (ClassNotFoundException ex) {
            objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        }
        DefaultGraphQLClient.objectMapper = objectMapper;
        objectMapper = new ObjectMapper[]{TuplesKt.to((Object)"Accept", (Object)CollectionsKt.listOf((Object)"application/json")), TuplesKt.to((Object)"Content-type", (Object)CollectionsKt.listOf((Object)"application/json"))};
        defaultHeaders = MapsKt.mapOf((Pair[])objectMapper);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/client/DefaultGraphQLClient$Companion;", "", "()V", "defaultHeaders", "", "", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Request", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/client/DefaultGraphQLClient$Companion$Request;", "", "query", "", "variables", "", "operationName", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getOperationName", "()Ljava/lang/String;", "getQuery", "getVariables", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-client"})
        private static final class Request {
            @NotNull
            private final String query;
            @NotNull
            private final Map<String, Object> variables;
            @Nullable
            private final String operationName;

            public Request(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                this.query = query;
                this.variables = variables;
                this.operationName = operationName;
            }

            @NotNull
            public final String getQuery() {
                return this.query;
            }

            @NotNull
            public final Map<String, Object> getVariables() {
                return this.variables;
            }

            @Nullable
            public final String getOperationName() {
                return this.operationName;
            }

            @NotNull
            public final String component1() {
                return this.query;
            }

            @NotNull
            public final Map<String, Object> component2() {
                return this.variables;
            }

            @Nullable
            public final String component3() {
                return this.operationName;
            }

            @NotNull
            public final Request copy(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                return new Request(query, variables, operationName);
            }

            public static /* synthetic */ Request copy$default(Request request, String string, Map map, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = request.query;
                }
                if ((n & 2) != 0) {
                    map = request.variables;
                }
                if ((n & 4) != 0) {
                    string2 = request.operationName;
                }
                return request.copy(string, map, string2);
            }

            @NotNull
            public String toString() {
                return "Request(query=" + this.query + ", variables=" + this.variables + ", operationName=" + this.operationName + ')';
            }

            public int hashCode() {
                int result = this.query.hashCode();
                result = result * 31 + ((Object)this.variables).hashCode();
                result = result * 31 + (this.operationName == null ? 0 : this.operationName.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Request)) {
                    return false;
                }
                Request request = (Request)other;
                if (!Intrinsics.areEqual((Object)this.query, (Object)request.query)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.variables, request.variables)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.operationName, (Object)request.operationName);
            }
        }
    }
}

