/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.OperationMessageWebSocketClient;
import com.netflix.graphql.types.subscription.OperationMessage;
import graphql.GraphQLException;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;", "", "url", "", "client", "Lorg/springframework/web/reactive/socket/client/WebSocketClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;)V", "errorSink", "Lreactor/core/publisher/Sinks$Many;", "Lgraphql/GraphQLException;", "kotlin.jvm.PlatformType", "incomingSink", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "outgoingSink", "connect", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "createMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "message", "decodeMessage", "exchange", "receive", "Lreactor/core/publisher/Flux;", "send", "", "Companion", "graphql-dgs-client"})
public final class OperationMessageWebSocketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final WebSocketClient client;
    private final Sinks.Many<OperationMessage> incomingSink;
    private final Sinks.Many<OperationMessage> outgoingSink;
    private final Sinks.Many<GraphQLException> errorSink;
    @NotNull
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper();

    public OperationMessageWebSocketClient(@NotNull String url, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.url = url;
        this.client = client;
        this.incomingSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.outgoingSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.errorSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
    }

    @NotNull
    public final Mono<Void> connect() {
        Mono mono = Mono.defer(() -> OperationMessageWebSocketClient.connect$lambda-0(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer { client.execute(URI(url), this::exchange) }");
        return mono;
    }

    public final void send(@NotNull OperationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.outgoingSink.tryEmitNext((Object)message).orThrow();
    }

    @NotNull
    public final Flux<OperationMessage> receive() {
        Flux flux = this.incomingSink.asFlux().mergeWith((Publisher)this.errorSink.asFlux().map((Function)receive.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"incomingSink\n            .asFlux()\n            .mergeWith(errorSink.asFlux().map { throw it })");
        return flux;
    }

    private final Mono<Void> exchange(WebSocketSession session) {
        Function1 function1 = (Function1)new Function1<OperationMessage, Unit>(this.incomingSink){

            public final void invoke(OperationMessage p0) {
                OperationMessageWebSocketClient.access$exchange$tryEmitNext((Sinks.Many)exchange.incomingDeserialized.2.access$getReceiver$p(this), p0);
            }

            public static final /* synthetic */ Object access$getReceiver$p(exchange.incomingDeserialized.2 $this) {
                return $this.receiver;
            }
        };
        Flux incomingDeserialized2 = session.receive().map(this::decodeMessage).doOnNext(new Consumer(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0) {
                this.function.invoke(p0);
            }
        });
        Mono outgoingSerialized = session.send((Publisher)this.outgoingSink.asFlux().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda-1(this, session, arg_0)));
        Publisher[] publisherArray = new Publisher[]{(Publisher)incomingDeserialized2, (Publisher)outgoingSerialized};
        Mono mono = Flux.merge((Publisher[])publisherArray).then().doOnError(arg_0 -> OperationMessageWebSocketClient.exchange$lambda-2(this, arg_0)).doAfterTerminate(() -> OperationMessageWebSocketClient.exchange$lambda-3(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"merge(incomingDeserialized, outgoingSerialized)\n            .then()\n            // Ensure the output flux collapses neatly if an error occurs\n            .doOnError { errorSink.tryEmitNext(GraphQLException(it)).orThrow() }\n            .doAfterTerminate { errorSink.tryEmitNext(GraphQLException(\"Server closed the connection unexpectedly\")).orThrow() }");
        return mono;
    }

    private final WebSocketMessage createMessage(WebSocketSession session, OperationMessage message) {
        WebSocketMessage webSocketMessage = session.textMessage(MAPPER.writeValueAsString((Object)message));
        Intrinsics.checkNotNullExpressionValue((Object)webSocketMessage, (String)"session.textMessage(MAPPER.writeValueAsString(message))");
        return webSocketMessage;
    }

    private final OperationMessage decodeMessage(WebSocketMessage message) {
        String messageText = message.getPayloadAsText();
        TypeReference<OperationMessage> type2 = new TypeReference<OperationMessage>(){};
        Object object = MAPPER.readValue(messageText, (TypeReference)type2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAPPER.readValue(messageText, type)");
        return (OperationMessage)object;
    }

    private static final Mono connect$lambda-0(OperationMessageWebSocketClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.client.execute(new URI(this$0.url), this$0::exchange);
    }

    private static final WebSocketMessage exchange$lambda-1(OperationMessageWebSocketClient this$0, WebSocketSession $session, OperationMessage it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.createMessage($session, it);
    }

    private static final void exchange$lambda-2(OperationMessageWebSocketClient this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.errorSink.tryEmitNext((Object)new GraphQLException(it)).orThrow();
    }

    private static final void exchange$lambda-3(OperationMessageWebSocketClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.errorSink.tryEmitNext((Object)new GraphQLException("Server closed the connection unexpectedly")).orThrow();
    }

    public static final /* synthetic */ void access$exchange$tryEmitNext(Sinks.Many $receiver, OperationMessage p0) {
        $receiver.tryEmitNext((Object)p0);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient$Companion;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

