/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.ClassUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLClients;", "", "()V", "defaultHeaders", "", "", "", "getDefaultHeaders$graphql_dgs_client", "()Ljava/util/Map;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper$graphql_dgs_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "url", "graphql-dgs-client"})
public final class GraphQLClients {
    @NotNull
    public static final GraphQLClients INSTANCE;
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final Map<String, List<String>> defaultHeaders;

    private GraphQLClients() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper$graphql_dgs_client() {
        return objectMapper;
    }

    @NotNull
    public final Map<String, List<String>> getDefaultHeaders$graphql_dgs_client() {
        return defaultHeaders;
    }

    @NotNull
    public final GraphQLResponse handleResponse(@NotNull HttpResponse response, @NotNull String requestBody, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpResponse httpResponse = response;
        int statusCode = httpResponse.component1();
        String body = httpResponse.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (!(200 <= statusCode ? statusCode <= 299 : false)) {
            String string = body;
            throw new GraphQLClientException(statusCode, url, string == null ? "" : string, requestBody);
        }
        String string = body;
        return new GraphQLResponse(string == null ? "" : string, headers);
    }

    static {
        ObjectMapper objectMapper;
        ObjectMapper objectMapper2;
        INSTANCE = new GraphQLClients();
        if (ClassUtils.isPresent((String)"com.fasterxml.jackson.module.kotlin.KotlinModule$Builder", (ClassLoader)INSTANCE.getClass().getClassLoader())) {
            objectMapper2 = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().nullIsSameAsDefault(true).build());
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"ObjectMapper().registerModule(KotlinModule.Builder().nullIsSameAsDefault(true).build())");
            objectMapper = objectMapper2;
        } else {
            objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        }
        GraphQLClients.objectMapper = objectMapper;
        objectMapper2 = new ObjectMapper[]{TuplesKt.to((Object)"Accept", (Object)CollectionsKt.listOf((Object)"application/json")), TuplesKt.to((Object)"Content-type", (Object)CollectionsKt.listOf((Object)"application/json"))};
        defaultHeaders = MapsKt.mapOf((Pair[])objectMapper2);
    }
}

