/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.client.GraphQLError;
import com.netflix.graphql.dgs.client.RequestDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006H\u00c6\u0003J/\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006H\u00c6\u0001J\u001f\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0019\u0010\"\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010#\u001a\u00020\u0003\u00a2\u0006\u0002\u0010$J'\u0010%\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010#\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u001b0'\u00a2\u0006\u0002\u0010(J'\u0010%\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010#\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020 J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "", "json", "", "(Ljava/lang/String;)V", "headers", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "data", "getData", "()Ljava/util/Map;", "errors", "Lcom/netflix/graphql/dgs/client/GraphQLError;", "getErrors", "()Ljava/util/List;", "getHeaders", "getJson", "()Ljava/lang/String;", "parsed", "Lcom/jayway/jsonpath/DocumentContext;", "getParsed", "()Lcom/jayway/jsonpath/DocumentContext;", "component1", "component2", "copy", "dataAsObject", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "equals", "", "other", "extractValue", "path", "(Ljava/lang/String;)Ljava/lang/Object;", "extractValueAsObject", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Lcom/jayway/jsonpath/TypeRef;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getDataPath", "getRequestDetails", "Lcom/netflix/graphql/dgs/client/RequestDetails;", "hasErrors", "hashCode", "", "toString", "Companion", "graphql-dgs-client"})
public final class GraphQLResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String json;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final DocumentContext parsed;
    @NotNull
    private final Map<String, Object> data;
    @NotNull
    private final List<GraphQLError> errors;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper mapper;
    @NotNull
    private static final Configuration jsonPathConfig;

    public GraphQLResponse(@NotNull String json, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.json = json;
        this.headers = headers;
        Object object = JsonPath.using((Configuration)jsonPathConfig).parse(this.json);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"using(jsonPathConfig).parse(json)");
        this.parsed = object;
        object = (Map)this.parsed.read("data", new Predicate[0]);
        this.data = object == null ? MapsKt.emptyMap() : object;
        object = (List)this.parsed.read("errors", (TypeRef)new TypeRef<List<? extends GraphQLError>>(){});
        this.errors = object == null ? CollectionsKt.emptyList() : object;
    }

    @NotNull
    public final String getJson() {
        return this.json;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final DocumentContext getParsed() {
        return this.parsed;
    }

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    @NotNull
    public final List<GraphQLError> getErrors() {
        return this.errors;
    }

    public GraphQLResponse(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this(json, MapsKt.emptyMap());
    }

    public final <T> T dataAsObject(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)mapper.convertValue(this.data, clazz);
    }

    public final <T> T extractValue(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String dataPath = this.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, new Predicate[0]);
        }
        catch (Exception ex) {
            logger.error("Error extracting path '" + path + "' from data: '" + this.data + '\'');
            throw ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String dataPath = this.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, clazz, new Predicate[0]);
        }
        catch (Exception ex) {
            logger.error("Error extracting path '" + path + "' from data: '" + this.data + '\'');
            throw ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull TypeRef<T> typeRef) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String dataPath = this.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, typeRef);
        }
        catch (Exception ex) {
            logger.error("Error extracting path '" + path + "' from data: '" + this.data + '\'');
            throw ex;
        }
    }

    @NotNull
    public final RequestDetails getRequestDetails() {
        return this.extractValueAsObject("gatewayRequestDetails", RequestDetails.class);
    }

    private final String getDataPath(String path) {
        return !StringsKt.startsWith$default((String)path, (String)"data", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)"data.", (Object)path) : path;
    }

    public final boolean hasErrors() {
        Collection collection = this.errors;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final String component1() {
        return this.json;
    }

    @NotNull
    public final Map<String, List<String>> component2() {
        return this.headers;
    }

    @NotNull
    public final GraphQLResponse copy(@NotNull String json, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return new GraphQLResponse(json, headers);
    }

    public static /* synthetic */ GraphQLResponse copy$default(GraphQLResponse graphQLResponse, String string, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = graphQLResponse.json;
        }
        if ((n & 2) != 0) {
            map = graphQLResponse.headers;
        }
        return graphQLResponse.copy(string, map);
    }

    @NotNull
    public String toString() {
        return "GraphQLResponse(json=" + this.json + ", headers=" + this.headers + ')';
    }

    public int hashCode() {
        int result = this.json.hashCode();
        result = result * 31 + ((Object)this.headers).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphQLResponse)) {
            return false;
        }
        GraphQLResponse graphQLResponse = (GraphQLResponse)other;
        if (!Intrinsics.areEqual((Object)this.json, (Object)graphQLResponse.json)) {
            return false;
        }
        return Intrinsics.areEqual(this.headers, graphQLResponse.headers);
    }

    static {
        Logger logger = LoggerFactory.getLogger(GraphQLResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(GraphQLResponse::class.java)");
        GraphQLResponse.logger = logger;
        logger = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"jacksonObjectMapper()\n            .registerModule(JavaTimeModule())\n            .registerModule(ParameterNamesModule())\n            .registerModule(Jdk8Module())\n            .enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)");
        mapper = logger;
        Option[] optionArray = new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL};
        logger = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(mapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(mapper)).build().addOptions(optionArray);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"builder()\n            .jsonProvider(JacksonJsonProvider(mapper))\n            .mappingProvider(JacksonMappingProvider(mapper)).build()\n            .addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL)");
        jsonPathConfig = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse$Companion;", "", "()V", "jsonPathConfig", "Lcom/jayway/jsonpath/Configuration;", "logger", "Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

