/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.types.subscription.QueryPayload;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/client/SSESubscriptionGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "url", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "encodeQuery", "query", "reactiveExecuteQuery", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class SSESubscriptionGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final ObjectMapper mapper;

    public SSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.url = url;
        this.webClient = webClient;
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        QueryPayload queryPayload = new QueryPayload(variables, MapsKt.emptyMap(), operationName, query);
        String jsonPayload = this.mapper.writeValueAsString((Object)queryPayload);
        WebClient.RequestHeadersUriSpec requestHeadersUriSpec = this.webClient.get();
        String string = Intrinsics.stringPlus((String)this.url, (Object)"?query={query}");
        Intrinsics.checkNotNullExpressionValue((Object)jsonPayload, (String)"jsonPayload");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_EVENT_STREAM};
        Flux flux = requestHeadersUriSpec.uri(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)this.encodeQuery(jsonPayload)))).accept(mediaTypeArray).exchange().flatMapMany(SSESubscriptionGraphQLClient::reactiveExecuteQuery$lambda-1).publishOn(Schedulers.single());
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"webClient.get()\n            .uri(\"$url?query={query}\", mapOf(\"query\" to encodeQuery(jsonPayload)))\n            .accept(MediaType.TEXT_EVENT_STREAM)\n            .exchange()\n            .flatMapMany { r ->\n                if (r.statusCode().is2xxSuccessful) {\n                    r.bodyToFlux<String>().map { GraphQLResponse(it, r.headers().asHttpHeaders()) }.onBackpressureBuffer()\n                } else {\n                    if (r.statusCode().is4xxClientError || r.statusCode().is3xxRedirection) {\n                        throw WebClientResponseException.create(r.rawStatusCode(), r.toString(), r.headers().asHttpHeaders(), byteArrayOf(), Charset.defaultCharset())\n                    } else {\n                        r.bodyToFlux<String>().map { throw WebClientResponseException.create(r.rawStatusCode(), r.toString(), r.headers().asHttpHeaders(), it.toByteArray(), Charset.defaultCharset()) }\n                    }\n                }\n            }\n            .publishOn(Schedulers.single())");
        return flux;
    }

    private final String encodeQuery(String query) {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = query;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return encoder.encodeToString(byArray);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda-1$lambda-0(ClientResponse $r, String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        HttpHeaders httpHeaders = $r.headers().asHttpHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"r.headers().asHttpHeaders()");
        return new GraphQLResponse(it, (Map)httpHeaders);
    }

    private static final Publisher reactiveExecuteQuery$lambda-1(ClientResponse r) {
        Flux flux;
        if (r.statusCode().is2xxSuccessful()) {
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            ClientResponse $this$bodyToFlux$iv = r;
            boolean $i$f$bodyToFlux = false;
            Flux flux2 = $this$bodyToFlux$iv.bodyToFlux((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
            Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"bodyToFlux(object : Para\u2026zedTypeReference<T>() {})");
            flux = flux2.map(arg_0 -> SSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda-1$lambda-0(r, arg_0)).onBackpressureBuffer();
        } else {
            if (r.statusCode().is4xxClientError() || r.statusCode().is3xxRedirection()) {
                WebClientResponseException $this$bodyToFlux$iv = WebClientResponseException.create((int)r.rawStatusCode(), (String)r.toString(), (HttpHeaders)r.headers().asHttpHeaders(), (byte[])new byte[0], (Charset)Charset.defaultCharset());
                Intrinsics.checkNotNullExpressionValue((Object)$this$bodyToFlux$iv, (String)"create(r.rawStatusCode(), r.toString(), r.headers().asHttpHeaders(), byteArrayOf(), Charset.defaultCharset())");
                throw (Throwable)$this$bodyToFlux$iv;
            }
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            ClientResponse $this$bodyToFlux$iv = r;
            boolean $i$f$bodyToFlux = false;
            Flux flux3 = $this$bodyToFlux$iv.bodyToFlux((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
            Intrinsics.checkExpressionValueIsNotNull((Object)flux3, (String)"bodyToFlux(object : Para\u2026zedTypeReference<T>() {})");
            flux = flux3.map(new Function(r){
                final /* synthetic */ ClientResponse $r;
                {
                    this.$r = $r;
                }

                public final Void apply(String it) {
                    int n = this.$r.rawStatusCode();
                    String string = this.$r.toString();
                    HttpHeaders httpHeaders = this.$r.headers().asHttpHeaders();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    String string2 = it;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    WebClientResponseException webClientResponseException = WebClientResponseException.create((int)n, (String)string, (HttpHeaders)httpHeaders, (byte[])byArray, (Charset)Charset.defaultCharset());
                    Intrinsics.checkNotNullExpressionValue((Object)webClientResponseException, (String)"create(r.rawStatusCode(), r.toString(), r.headers().asHttpHeaders(), it.toByteArray(), Charset.defaultCharset())");
                    throw (Throwable)webClientResponseException;
                }
            });
        }
        return (Publisher)flux;
    }
}

