/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.Request;
import com.netflix.graphql.dgs.client.RequestExecutor;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bH\u0016J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/client/CustomGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "url", "", "requestExecutor", "Lcom/netflix/graphql/dgs/client/RequestExecutor;", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/client/RequestExecutor;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class CustomGraphQLClient
implements GraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final RequestExecutor requestExecutor;

    public CustomGraphQLClient(@NotNull String url, @NotNull RequestExecutor requestExecutor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        this.url = url;
        this.requestExecutor = requestExecutor;
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.executeQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.executeQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client().writeValueAsString((Object)new Request(query, variables, operationName));
        Map<String, List<String>> map = GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client();
        Intrinsics.checkNotNullExpressionValue((Object)serializedRequest, (String)"serializedRequest");
        HttpResponse response = this.requestExecutor.execute(this.url, map, serializedRequest);
        return GraphQLClients.INSTANCE.handleResponse(response, serializedRequest, this.url);
    }

    @Override
    @Deprecated(message="The RequestExecutor should be provided while creating the implementation.", replaceWith=@ReplaceWith(expression="Example: new DefaultGraphQLClient(url, requestExecutor);", imports={}))
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull RequestExecutor requestExecutor) {
        return GraphQLClient.DefaultImpls.executeQuery(this, query, variables, operationName, requestExecutor);
    }

    @Override
    @Deprecated(message="The RequestExecutor should be provided while creating the implementation.", replaceWith=@ReplaceWith(expression="Example: new DefaultGraphQLClient(url, requestExecutor);", imports={}))
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull RequestExecutor requestExecutor) {
        return GraphQLClient.DefaultImpls.executeQuery(this, query, variables, requestExecutor);
    }
}

