/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.MonoRequestExecutor;
import com.netflix.graphql.dgs.client.Request;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "webclient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Lorg/springframework/web/reactive/function/client/WebClient;)V", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "(Lorg/springframework/web/reactive/function/client/WebClient;Ljava/util/function/Consumer;)V", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class WebClientGraphQLClient
implements MonoGraphQLClient {
    @NotNull
    private final WebClient webclient;
    @Nullable
    private final Consumer<HttpHeaders> headersConsumer;

    public WebClientGraphQLClient(@NotNull WebClient webclient, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        this.webclient = webclient;
        this.headersConsumer = headersConsumer;
    }

    public WebClientGraphQLClient(@NotNull WebClient webclient) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        this(webclient, null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client().writeValueAsString((Object)new Request(query, variables, operationName));
        Consumer<HttpHeaders> consumer = this.headersConsumer;
        Mono mono = this.webclient.post().bodyValue((Object)serializedRequest).headers(WebClientGraphQLClient::reactiveExecuteQuery$lambda-0).headers(consumer == null ? WebClientGraphQLClient::reactiveExecuteQuery$lambda-1 : consumer).exchange().flatMap(WebClientGraphQLClient::reactiveExecuteQuery$lambda-3).map(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda-4(this, serializedRequest, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"webclient.post()\n       \u2026nse, serializedRequest) }");
        return mono;
    }

    private final GraphQLResponse handleResponse(HttpResponse response, String requestBody) {
        HttpResponse httpResponse = response;
        int statusCode = httpResponse.component1();
        String body = httpResponse.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (!(200 <= statusCode ? statusCode <= 299 : false)) {
            String string;
            throw new GraphQLClientException(statusCode, this.webclient.toString(), (string = body) == null ? "" : string, requestBody);
        }
        String string = body;
        return new GraphQLResponse(string == null ? "" : string, headers);
    }

    @Override
    @Deprecated(message="The RequestExecutor should be provided while creating the implementation. Use CustomGraphQLClient/CustomMonoGraphQLClient instead.", replaceWith=@ReplaceWith(expression="Example: new CustomGraphQLClient(url, requestExecutor);", imports={}))
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull MonoRequestExecutor requestExecutor) {
        return MonoGraphQLClient.DefaultImpls.reactiveExecuteQuery(this, query, variables, operationName, requestExecutor);
    }

    @Override
    @Deprecated(message="The RequestExecutor should be provided while creating the implementation. Use CustomGraphQLClient/CustomMonoGraphQLClient instead.", replaceWith=@ReplaceWith(expression="Example: new CustomGraphQLClient(url, requestExecutor);", imports={}))
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull MonoRequestExecutor requestExecutor) {
        return MonoGraphQLClient.DefaultImpls.reactiveExecuteQuery(this, query, variables, requestExecutor);
    }

    private static final void reactiveExecuteQuery$lambda-0(HttpHeaders consumer) {
        GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client().forEach((arg_0, arg_1) -> ((HttpHeaders)consumer).addAll(arg_0, arg_1));
    }

    private static final void reactiveExecuteQuery$lambda-1(HttpHeaders it) {
    }

    private static final HttpResponse reactiveExecuteQuery$lambda-3$lambda-2(ClientResponse $r, String respBody) {
        int n = $r.rawStatusCode();
        HttpHeaders httpHeaders = $r.headers().asHttpHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"r.headers().asHttpHeaders()");
        return new HttpResponse(n, respBody, (Map)httpHeaders);
    }

    private static final Mono reactiveExecuteQuery$lambda-3(ClientResponse r) {
        return r.bodyToMono(String.class).map(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda-3$lambda-2(r, arg_0));
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda-4(WebClientGraphQLClient this$0, String $serializedRequest, HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullExpressionValue((Object)$serializedRequest, (String)"serializedRequest");
        return this$0.handleResponse(httpResponse, $serializedRequest);
    }
}

