/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.types.subscription.QueryPayload;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/client/SSESubscriptionGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "url", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "encodeQuery", "query", "reactiveExecuteQuery", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class SSESubscriptionGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    private final String url;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final ObjectMapper mapper;

    public SSESubscriptionGraphQLClient(@NotNull String url, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.url = url;
        this.webClient = webClient;
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        void $this$toEntityFlux$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        QueryPayload queryPayload = new QueryPayload(variables, MapsKt.emptyMap(), operationName, query);
        String jsonPayload = this.mapper.writeValueAsString((Object)queryPayload);
        WebClient.RequestHeadersUriSpec requestHeadersUriSpec = this.webClient.get();
        String string = this.url + "?query={query}";
        Intrinsics.checkNotNullExpressionValue((Object)jsonPayload, (String)"jsonPayload");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_EVENT_STREAM};
        WebClient.ResponseSpec responseSpec = requestHeadersUriSpec.uri(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)this.encodeQuery(jsonPayload)))).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"webClient.get()\n        \u2026)\n            .retrieve()");
        boolean $i$f$toEntityFlux = false;
        Mono mono = $this$toEntityFlux$iv.toEntityFlux((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"toEntityFlux(object : Pa\u2026zedTypeReference<T>() {})");
        Flux flux = mono.flatMapMany(SSESubscriptionGraphQLClient::reactiveExecuteQuery$lambda-1).publishOn(Schedulers.single());
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"webClient.get()\n        \u2026shOn(Schedulers.single())");
        return flux;
    }

    private final String encodeQuery(String query) {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = query;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return encoder.encodeToString(byArray);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda-1$lambda-0(HttpHeaders $headers, String body) {
        Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
        Intrinsics.checkNotNullExpressionValue((Object)$headers, (String)"headers");
        return new GraphQLResponse(body, (Map)$headers);
    }

    private static final Publisher reactiveExecuteQuery$lambda-1(ResponseEntity response) {
        HttpHeaders headers = response.getHeaders();
        Flux flux = (Flux)response.getBody();
        return flux != null && (flux = flux.map(arg_0 -> SSESubscriptionGraphQLClient.reactiveExecuteQuery$lambda-1$lambda-0(headers, arg_0))) != null ? (Publisher)flux : (Publisher)Flux.empty();
    }
}

